/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.fileclassifications;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.fileclassifications.AddClassificationToFileHeaders;
import com.box.sdkgen.managers.fileclassifications.AddClassificationToFileRequestBody;
import com.box.sdkgen.managers.fileclassifications.DeleteClassificationFromFileHeaders;
import com.box.sdkgen.managers.fileclassifications.GetClassificationOnFileHeaders;
import com.box.sdkgen.managers.fileclassifications.UpdateClassificationOnFileHeaders;
import com.box.sdkgen.managers.fileclassifications.UpdateClassificationOnFileRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.classification.Classification;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.List;
import java.util.Map;

public class FileClassificationsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FileClassificationsManager() {
        this.networkSession = new NetworkSession();
    }

    protected FileClassificationsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Classification getClassificationOnFile(String fileId) {
        return this.getClassificationOnFile(fileId, new GetClassificationOnFileHeaders());
    }

    public Classification getClassificationOnFile(String fileId, GetClassificationOnFileHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/metadata/enterprise/securityClassification-6VMVochwUWo"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Classification.class);
    }

    public Classification addClassificationToFile(String fileId) {
        return this.addClassificationToFile(fileId, new AddClassificationToFileRequestBody(), new AddClassificationToFileHeaders());
    }

    public Classification addClassificationToFile(String fileId, AddClassificationToFileRequestBody requestBody) {
        return this.addClassificationToFile(fileId, requestBody, new AddClassificationToFileHeaders());
    }

    public Classification addClassificationToFile(String fileId, AddClassificationToFileHeaders headers) {
        return this.addClassificationToFile(fileId, new AddClassificationToFileRequestBody(), headers);
    }

    public Classification addClassificationToFile(String fileId, AddClassificationToFileRequestBody requestBody, AddClassificationToFileHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/metadata/enterprise/securityClassification-6VMVochwUWo"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Classification.class);
    }

    public Classification updateClassificationOnFile(String fileId, List<UpdateClassificationOnFileRequestBody> requestBody) {
        return this.updateClassificationOnFile(fileId, requestBody, new UpdateClassificationOnFileHeaders());
    }

    public Classification updateClassificationOnFile(String fileId, List<UpdateClassificationOnFileRequestBody> requestBody, UpdateClassificationOnFileHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/metadata/enterprise/securityClassification-6VMVochwUWo"), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json-patch+json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Classification.class);
    }

    public void deleteClassificationFromFile(String fileId) {
        this.deleteClassificationFromFile(fileId, new DeleteClassificationFromFileHeaders());
    }

    public void deleteClassificationFromFile(String fileId, DeleteClassificationFromFileHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/metadata/enterprise/securityClassification-6VMVochwUWo"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FileClassificationsManager build() {
            return new FileClassificationsManager(this);
        }
    }
}

