/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.invites;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.invites.CreateInviteHeaders;
import com.box.sdkgen.managers.invites.CreateInviteQueryParams;
import com.box.sdkgen.managers.invites.CreateInviteRequestBody;
import com.box.sdkgen.managers.invites.GetInviteByIdHeaders;
import com.box.sdkgen.managers.invites.GetInviteByIdQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.invite.Invite;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class InvitesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public InvitesManager() {
        this.networkSession = new NetworkSession();
    }

    protected InvitesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Invite createInvite(CreateInviteRequestBody requestBody) {
        return this.createInvite(requestBody, new CreateInviteQueryParams(), new CreateInviteHeaders());
    }

    public Invite createInvite(CreateInviteRequestBody requestBody, CreateInviteQueryParams queryParams) {
        return this.createInvite(requestBody, queryParams, new CreateInviteHeaders());
    }

    public Invite createInvite(CreateInviteRequestBody requestBody, CreateInviteHeaders headers) {
        return this.createInvite(requestBody, new CreateInviteQueryParams(), headers);
    }

    public Invite createInvite(CreateInviteRequestBody requestBody, CreateInviteQueryParams queryParams, CreateInviteHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/invites"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Invite.class);
    }

    public Invite getInviteById(String inviteId) {
        return this.getInviteById(inviteId, new GetInviteByIdQueryParams(), new GetInviteByIdHeaders());
    }

    public Invite getInviteById(String inviteId, GetInviteByIdQueryParams queryParams) {
        return this.getInviteById(inviteId, queryParams, new GetInviteByIdHeaders());
    }

    public Invite getInviteById(String inviteId, GetInviteByIdHeaders headers) {
        return this.getInviteById(inviteId, new GetInviteByIdQueryParams(), headers);
    }

    public Invite getInviteById(String inviteId, GetInviteByIdQueryParams queryParams, GetInviteByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/invites/", UtilsManager.convertToString(inviteId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Invite.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public InvitesManager build() {
            return new InvitesManager(this);
        }
    }
}

