/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.legalholdpolicyassignments;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.legalholdpolicyassignments.CreateLegalHoldPolicyAssignmentHeaders;
import com.box.sdkgen.managers.legalholdpolicyassignments.CreateLegalHoldPolicyAssignmentRequestBody;
import com.box.sdkgen.managers.legalholdpolicyassignments.DeleteLegalHoldPolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.legalholdpolicyassignments.GetLegalHoldPolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.legalholdpolicyassignments.GetLegalHoldPolicyAssignmentFileOnHoldHeaders;
import com.box.sdkgen.managers.legalholdpolicyassignments.GetLegalHoldPolicyAssignmentFileOnHoldQueryParams;
import com.box.sdkgen.managers.legalholdpolicyassignments.GetLegalHoldPolicyAssignmentsHeaders;
import com.box.sdkgen.managers.legalholdpolicyassignments.GetLegalHoldPolicyAssignmentsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.filesonhold.FilesOnHold;
import com.box.sdkgen.schemas.legalholdpolicyassignment.LegalHoldPolicyAssignment;
import com.box.sdkgen.schemas.legalholdpolicyassignments.LegalHoldPolicyAssignments;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class LegalHoldPolicyAssignmentsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public LegalHoldPolicyAssignmentsManager() {
        this.networkSession = new NetworkSession();
    }

    protected LegalHoldPolicyAssignmentsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public LegalHoldPolicyAssignments getLegalHoldPolicyAssignments(GetLegalHoldPolicyAssignmentsQueryParams queryParams) {
        return this.getLegalHoldPolicyAssignments(queryParams, new GetLegalHoldPolicyAssignmentsHeaders());
    }

    public LegalHoldPolicyAssignments getLegalHoldPolicyAssignments(GetLegalHoldPolicyAssignmentsQueryParams queryParams, GetLegalHoldPolicyAssignmentsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("policy_id", UtilsManager.convertToString(queryParams.getPolicyId())), UtilsManager.entryOf("assign_to_type", UtilsManager.convertToString(queryParams.getAssignToType())), UtilsManager.entryOf("assign_to_id", UtilsManager.convertToString(queryParams.getAssignToId())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policy_assignments"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicyAssignments.class);
    }

    public LegalHoldPolicyAssignment createLegalHoldPolicyAssignment(CreateLegalHoldPolicyAssignmentRequestBody requestBody) {
        return this.createLegalHoldPolicyAssignment(requestBody, new CreateLegalHoldPolicyAssignmentHeaders());
    }

    public LegalHoldPolicyAssignment createLegalHoldPolicyAssignment(CreateLegalHoldPolicyAssignmentRequestBody requestBody, CreateLegalHoldPolicyAssignmentHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policy_assignments"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicyAssignment.class);
    }

    public LegalHoldPolicyAssignment getLegalHoldPolicyAssignmentById(String legalHoldPolicyAssignmentId) {
        return this.getLegalHoldPolicyAssignmentById(legalHoldPolicyAssignmentId, new GetLegalHoldPolicyAssignmentByIdHeaders());
    }

    public LegalHoldPolicyAssignment getLegalHoldPolicyAssignmentById(String legalHoldPolicyAssignmentId, GetLegalHoldPolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policy_assignments/", UtilsManager.convertToString(legalHoldPolicyAssignmentId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicyAssignment.class);
    }

    public void deleteLegalHoldPolicyAssignmentById(String legalHoldPolicyAssignmentId) {
        this.deleteLegalHoldPolicyAssignmentById(legalHoldPolicyAssignmentId, new DeleteLegalHoldPolicyAssignmentByIdHeaders());
    }

    public void deleteLegalHoldPolicyAssignmentById(String legalHoldPolicyAssignmentId, DeleteLegalHoldPolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policy_assignments/", UtilsManager.convertToString(legalHoldPolicyAssignmentId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public FilesOnHold getLegalHoldPolicyAssignmentFileOnHold(String legalHoldPolicyAssignmentId) {
        return this.getLegalHoldPolicyAssignmentFileOnHold(legalHoldPolicyAssignmentId, new GetLegalHoldPolicyAssignmentFileOnHoldQueryParams(), new GetLegalHoldPolicyAssignmentFileOnHoldHeaders());
    }

    public FilesOnHold getLegalHoldPolicyAssignmentFileOnHold(String legalHoldPolicyAssignmentId, GetLegalHoldPolicyAssignmentFileOnHoldQueryParams queryParams) {
        return this.getLegalHoldPolicyAssignmentFileOnHold(legalHoldPolicyAssignmentId, queryParams, new GetLegalHoldPolicyAssignmentFileOnHoldHeaders());
    }

    public FilesOnHold getLegalHoldPolicyAssignmentFileOnHold(String legalHoldPolicyAssignmentId, GetLegalHoldPolicyAssignmentFileOnHoldHeaders headers) {
        return this.getLegalHoldPolicyAssignmentFileOnHold(legalHoldPolicyAssignmentId, new GetLegalHoldPolicyAssignmentFileOnHoldQueryParams(), headers);
    }

    public FilesOnHold getLegalHoldPolicyAssignmentFileOnHold(String legalHoldPolicyAssignmentId, GetLegalHoldPolicyAssignmentFileOnHoldQueryParams queryParams, GetLegalHoldPolicyAssignmentFileOnHoldHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policy_assignments/", UtilsManager.convertToString(legalHoldPolicyAssignmentId), "/files_on_hold"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FilesOnHold.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public LegalHoldPolicyAssignmentsManager build() {
            return new LegalHoldPolicyAssignmentsManager(this);
        }
    }
}

