/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.metadatacascadepolicies;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.metadatacascadepolicies.ApplyMetadataCascadePolicyHeaders;
import com.box.sdkgen.managers.metadatacascadepolicies.ApplyMetadataCascadePolicyRequestBody;
import com.box.sdkgen.managers.metadatacascadepolicies.CreateMetadataCascadePolicyHeaders;
import com.box.sdkgen.managers.metadatacascadepolicies.CreateMetadataCascadePolicyRequestBody;
import com.box.sdkgen.managers.metadatacascadepolicies.DeleteMetadataCascadePolicyByIdHeaders;
import com.box.sdkgen.managers.metadatacascadepolicies.GetMetadataCascadePoliciesHeaders;
import com.box.sdkgen.managers.metadatacascadepolicies.GetMetadataCascadePoliciesQueryParams;
import com.box.sdkgen.managers.metadatacascadepolicies.GetMetadataCascadePolicyByIdHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.metadatacascadepolicies.MetadataCascadePolicies;
import com.box.sdkgen.schemas.metadatacascadepolicy.MetadataCascadePolicy;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class MetadataCascadePoliciesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public MetadataCascadePoliciesManager() {
        this.networkSession = new NetworkSession();
    }

    protected MetadataCascadePoliciesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public MetadataCascadePolicies getMetadataCascadePolicies(GetMetadataCascadePoliciesQueryParams queryParams) {
        return this.getMetadataCascadePolicies(queryParams, new GetMetadataCascadePoliciesHeaders());
    }

    public MetadataCascadePolicies getMetadataCascadePolicies(GetMetadataCascadePoliciesQueryParams queryParams, GetMetadataCascadePoliciesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("folder_id", UtilsManager.convertToString(queryParams.getFolderId())), UtilsManager.entryOf("owner_enterprise_id", UtilsManager.convertToString(queryParams.getOwnerEnterpriseId())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_cascade_policies"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataCascadePolicies.class);
    }

    public MetadataCascadePolicy createMetadataCascadePolicy(CreateMetadataCascadePolicyRequestBody requestBody) {
        return this.createMetadataCascadePolicy(requestBody, new CreateMetadataCascadePolicyHeaders());
    }

    public MetadataCascadePolicy createMetadataCascadePolicy(CreateMetadataCascadePolicyRequestBody requestBody, CreateMetadataCascadePolicyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_cascade_policies"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataCascadePolicy.class);
    }

    public MetadataCascadePolicy getMetadataCascadePolicyById(String metadataCascadePolicyId) {
        return this.getMetadataCascadePolicyById(metadataCascadePolicyId, new GetMetadataCascadePolicyByIdHeaders());
    }

    public MetadataCascadePolicy getMetadataCascadePolicyById(String metadataCascadePolicyId, GetMetadataCascadePolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_cascade_policies/", UtilsManager.convertToString(metadataCascadePolicyId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataCascadePolicy.class);
    }

    public void deleteMetadataCascadePolicyById(String metadataCascadePolicyId) {
        this.deleteMetadataCascadePolicyById(metadataCascadePolicyId, new DeleteMetadataCascadePolicyByIdHeaders());
    }

    public void deleteMetadataCascadePolicyById(String metadataCascadePolicyId, DeleteMetadataCascadePolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_cascade_policies/", UtilsManager.convertToString(metadataCascadePolicyId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public void applyMetadataCascadePolicy(String metadataCascadePolicyId, ApplyMetadataCascadePolicyRequestBody requestBody) {
        this.applyMetadataCascadePolicy(metadataCascadePolicyId, requestBody, new ApplyMetadataCascadePolicyHeaders());
    }

    public void applyMetadataCascadePolicy(String metadataCascadePolicyId, ApplyMetadataCascadePolicyRequestBody requestBody, ApplyMetadataCascadePolicyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_cascade_policies/", UtilsManager.convertToString(metadataCascadePolicyId), "/apply"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public MetadataCascadePoliciesManager build() {
            return new MetadataCascadePoliciesManager(this);
        }
    }
}

