/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.retentionpolicies;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.retentionpolicies.CreateRetentionPolicyHeaders;
import com.box.sdkgen.managers.retentionpolicies.CreateRetentionPolicyRequestBody;
import com.box.sdkgen.managers.retentionpolicies.DeleteRetentionPolicyByIdHeaders;
import com.box.sdkgen.managers.retentionpolicies.GetRetentionPoliciesHeaders;
import com.box.sdkgen.managers.retentionpolicies.GetRetentionPoliciesQueryParams;
import com.box.sdkgen.managers.retentionpolicies.GetRetentionPolicyByIdHeaders;
import com.box.sdkgen.managers.retentionpolicies.GetRetentionPolicyByIdQueryParams;
import com.box.sdkgen.managers.retentionpolicies.UpdateRetentionPolicyByIdHeaders;
import com.box.sdkgen.managers.retentionpolicies.UpdateRetentionPolicyByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.retentionpolicies.RetentionPolicies;
import com.box.sdkgen.schemas.retentionpolicy.RetentionPolicy;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class RetentionPoliciesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public RetentionPoliciesManager() {
        this.networkSession = new NetworkSession();
    }

    protected RetentionPoliciesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public RetentionPolicies getRetentionPolicies() {
        return this.getRetentionPolicies(new GetRetentionPoliciesQueryParams(), new GetRetentionPoliciesHeaders());
    }

    public RetentionPolicies getRetentionPolicies(GetRetentionPoliciesQueryParams queryParams) {
        return this.getRetentionPolicies(queryParams, new GetRetentionPoliciesHeaders());
    }

    public RetentionPolicies getRetentionPolicies(GetRetentionPoliciesHeaders headers) {
        return this.getRetentionPolicies(new GetRetentionPoliciesQueryParams(), headers);
    }

    public RetentionPolicies getRetentionPolicies(GetRetentionPoliciesQueryParams queryParams, GetRetentionPoliciesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("policy_name", UtilsManager.convertToString(queryParams.getPolicyName())), UtilsManager.entryOf("policy_type", UtilsManager.convertToString(queryParams.getPolicyType())), UtilsManager.entryOf("created_by_user_id", UtilsManager.convertToString(queryParams.getCreatedByUserId())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicies.class);
    }

    public RetentionPolicy createRetentionPolicy(CreateRetentionPolicyRequestBody requestBody) {
        return this.createRetentionPolicy(requestBody, new CreateRetentionPolicyHeaders());
    }

    public RetentionPolicy createRetentionPolicy(CreateRetentionPolicyRequestBody requestBody, CreateRetentionPolicyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicy.class);
    }

    public RetentionPolicy getRetentionPolicyById(String retentionPolicyId) {
        return this.getRetentionPolicyById(retentionPolicyId, new GetRetentionPolicyByIdQueryParams(), new GetRetentionPolicyByIdHeaders());
    }

    public RetentionPolicy getRetentionPolicyById(String retentionPolicyId, GetRetentionPolicyByIdQueryParams queryParams) {
        return this.getRetentionPolicyById(retentionPolicyId, queryParams, new GetRetentionPolicyByIdHeaders());
    }

    public RetentionPolicy getRetentionPolicyById(String retentionPolicyId, GetRetentionPolicyByIdHeaders headers) {
        return this.getRetentionPolicyById(retentionPolicyId, new GetRetentionPolicyByIdQueryParams(), headers);
    }

    public RetentionPolicy getRetentionPolicyById(String retentionPolicyId, GetRetentionPolicyByIdQueryParams queryParams, GetRetentionPolicyByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies/", UtilsManager.convertToString(retentionPolicyId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicy.class);
    }

    public RetentionPolicy updateRetentionPolicyById(String retentionPolicyId) {
        return this.updateRetentionPolicyById(retentionPolicyId, new UpdateRetentionPolicyByIdRequestBody(), new UpdateRetentionPolicyByIdHeaders());
    }

    public RetentionPolicy updateRetentionPolicyById(String retentionPolicyId, UpdateRetentionPolicyByIdRequestBody requestBody) {
        return this.updateRetentionPolicyById(retentionPolicyId, requestBody, new UpdateRetentionPolicyByIdHeaders());
    }

    public RetentionPolicy updateRetentionPolicyById(String retentionPolicyId, UpdateRetentionPolicyByIdHeaders headers) {
        return this.updateRetentionPolicyById(retentionPolicyId, new UpdateRetentionPolicyByIdRequestBody(), headers);
    }

    public RetentionPolicy updateRetentionPolicyById(String retentionPolicyId, UpdateRetentionPolicyByIdRequestBody requestBody, UpdateRetentionPolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies/", UtilsManager.convertToString(retentionPolicyId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicy.class);
    }

    public void deleteRetentionPolicyById(String retentionPolicyId) {
        this.deleteRetentionPolicyById(retentionPolicyId, new DeleteRetentionPolicyByIdHeaders());
    }

    public void deleteRetentionPolicyById(String retentionPolicyId, DeleteRetentionPolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies/", UtilsManager.convertToString(retentionPolicyId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public RetentionPoliciesManager build() {
            return new RetentionPoliciesManager(this);
        }
    }
}

