/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.tasks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.tasks.CreateTaskHeaders;
import com.box.sdkgen.managers.tasks.CreateTaskRequestBody;
import com.box.sdkgen.managers.tasks.DeleteTaskByIdHeaders;
import com.box.sdkgen.managers.tasks.GetFileTasksHeaders;
import com.box.sdkgen.managers.tasks.GetTaskByIdHeaders;
import com.box.sdkgen.managers.tasks.UpdateTaskByIdHeaders;
import com.box.sdkgen.managers.tasks.UpdateTaskByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.task.Task;
import com.box.sdkgen.schemas.tasks.Tasks;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TasksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TasksManager() {
        this.networkSession = new NetworkSession();
    }

    protected TasksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Tasks getFileTasks(String fileId) {
        return this.getFileTasks(fileId, new GetFileTasksHeaders());
    }

    public Tasks getFileTasks(String fileId, GetFileTasksHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/tasks"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Tasks.class);
    }

    public Task createTask(CreateTaskRequestBody requestBody) {
        return this.createTask(requestBody, new CreateTaskHeaders());
    }

    public Task createTask(CreateTaskRequestBody requestBody, CreateTaskHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/tasks"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Task.class);
    }

    public Task getTaskById(String taskId) {
        return this.getTaskById(taskId, new GetTaskByIdHeaders());
    }

    public Task getTaskById(String taskId, GetTaskByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/tasks/", UtilsManager.convertToString(taskId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Task.class);
    }

    public Task updateTaskById(String taskId) {
        return this.updateTaskById(taskId, new UpdateTaskByIdRequestBody(), new UpdateTaskByIdHeaders());
    }

    public Task updateTaskById(String taskId, UpdateTaskByIdRequestBody requestBody) {
        return this.updateTaskById(taskId, requestBody, new UpdateTaskByIdHeaders());
    }

    public Task updateTaskById(String taskId, UpdateTaskByIdHeaders headers) {
        return this.updateTaskById(taskId, new UpdateTaskByIdRequestBody(), headers);
    }

    public Task updateTaskById(String taskId, UpdateTaskByIdRequestBody requestBody, UpdateTaskByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/tasks/", UtilsManager.convertToString(taskId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Task.class);
    }

    public void deleteTaskById(String taskId) {
        this.deleteTaskById(taskId, new DeleteTaskByIdHeaders());
    }

    public void deleteTaskById(String taskId, DeleteTaskByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/tasks/", UtilsManager.convertToString(taskId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TasksManager build() {
            return new TasksManager(this);
        }
    }
}

