/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.trashedweblinks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.trashedweblinks.DeleteTrashedWebLinkByIdHeaders;
import com.box.sdkgen.managers.trashedweblinks.GetTrashedWebLinkByIdHeaders;
import com.box.sdkgen.managers.trashedweblinks.GetTrashedWebLinkByIdQueryParams;
import com.box.sdkgen.managers.trashedweblinks.RestoreWeblinkFromTrashHeaders;
import com.box.sdkgen.managers.trashedweblinks.RestoreWeblinkFromTrashQueryParams;
import com.box.sdkgen.managers.trashedweblinks.RestoreWeblinkFromTrashRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.trashweblink.TrashWebLink;
import com.box.sdkgen.schemas.trashweblinkrestored.TrashWebLinkRestored;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TrashedWebLinksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TrashedWebLinksManager() {
        this.networkSession = new NetworkSession();
    }

    protected TrashedWebLinksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId) {
        return this.restoreWeblinkFromTrash(webLinkId, new RestoreWeblinkFromTrashRequestBody(), new RestoreWeblinkFromTrashQueryParams(), new RestoreWeblinkFromTrashHeaders());
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashRequestBody requestBody) {
        return this.restoreWeblinkFromTrash(webLinkId, requestBody, new RestoreWeblinkFromTrashQueryParams(), new RestoreWeblinkFromTrashHeaders());
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashQueryParams queryParams) {
        return this.restoreWeblinkFromTrash(webLinkId, new RestoreWeblinkFromTrashRequestBody(), queryParams, new RestoreWeblinkFromTrashHeaders());
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashRequestBody requestBody, RestoreWeblinkFromTrashQueryParams queryParams) {
        return this.restoreWeblinkFromTrash(webLinkId, requestBody, queryParams, new RestoreWeblinkFromTrashHeaders());
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashHeaders headers) {
        return this.restoreWeblinkFromTrash(webLinkId, new RestoreWeblinkFromTrashRequestBody(), new RestoreWeblinkFromTrashQueryParams(), headers);
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashRequestBody requestBody, RestoreWeblinkFromTrashHeaders headers) {
        return this.restoreWeblinkFromTrash(webLinkId, requestBody, new RestoreWeblinkFromTrashQueryParams(), headers);
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashQueryParams queryParams, RestoreWeblinkFromTrashHeaders headers) {
        return this.restoreWeblinkFromTrash(webLinkId, new RestoreWeblinkFromTrashRequestBody(), queryParams, headers);
    }

    public TrashWebLinkRestored restoreWeblinkFromTrash(String webLinkId, RestoreWeblinkFromTrashRequestBody requestBody, RestoreWeblinkFromTrashQueryParams queryParams, RestoreWeblinkFromTrashHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId)), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TrashWebLinkRestored.class);
    }

    public TrashWebLink getTrashedWebLinkById(String webLinkId) {
        return this.getTrashedWebLinkById(webLinkId, new GetTrashedWebLinkByIdQueryParams(), new GetTrashedWebLinkByIdHeaders());
    }

    public TrashWebLink getTrashedWebLinkById(String webLinkId, GetTrashedWebLinkByIdQueryParams queryParams) {
        return this.getTrashedWebLinkById(webLinkId, queryParams, new GetTrashedWebLinkByIdHeaders());
    }

    public TrashWebLink getTrashedWebLinkById(String webLinkId, GetTrashedWebLinkByIdHeaders headers) {
        return this.getTrashedWebLinkById(webLinkId, new GetTrashedWebLinkByIdQueryParams(), headers);
    }

    public TrashWebLink getTrashedWebLinkById(String webLinkId, GetTrashedWebLinkByIdQueryParams queryParams, GetTrashedWebLinkByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "/trash"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TrashWebLink.class);
    }

    public void deleteTrashedWebLinkById(String webLinkId) {
        this.deleteTrashedWebLinkById(webLinkId, new DeleteTrashedWebLinkByIdHeaders());
    }

    public void deleteTrashedWebLinkById(String webLinkId, DeleteTrashedWebLinkByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/web_links/", UtilsManager.convertToString(webLinkId), "/trash"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TrashedWebLinksManager build() {
            return new TrashedWebLinksManager(this);
        }
    }
}

