/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.networking.boxnetworkclient;

import com.box.sdkgen.box.BoxConstants;
import com.box.sdkgen.box.errors.BoxAPIError;
import com.box.sdkgen.box.errors.BoxSDKError;
import com.box.sdkgen.internal.logging.DataSanitizer;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.MultipartItem;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.networking.networkclient.NetworkClient;
import com.box.sdkgen.networking.proxyconfig.ProxyConfig;
import com.box.sdkgen.serialization.json.JsonManager;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class BoxNetworkClient
implements NetworkClient {
    private static final int BASE_TIMEOUT = 1;
    private static final double RANDOM_FACTOR = 0.5;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    protected OkHttpClient httpClient;

    public BoxNetworkClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BoxNetworkClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followSslRedirects(true).followRedirects(false).connectionSpecs(Collections.singletonList(ConnectionSpec.MODERN_TLS));
        this.httpClient = builder.build();
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public BoxNetworkClient withProxy(ProxyConfig config) {
        URI uri = URI.create(config.getUrl());
        String host = Objects.requireNonNull(uri.getHost(), "Invalid Proxy URL");
        String scheme = Optional.ofNullable(uri.getScheme()).filter(schema -> schema.startsWith("http")).orElseThrow(() -> new IllegalArgumentException("Invalid Proxy URL: " + uri));
        int port = uri.getPort() != -1 ? uri.getPort() : ("https".equalsIgnoreCase(scheme) ? 443 : 80);
        OkHttpClient.Builder clientBuilder = this.httpClient.newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        String username = config.getUsername();
        String password = config.getPassword();
        if (username != null && !username.trim().isEmpty() && password != null) {
            String basic = Credentials.basic((String)username, (String)password, (Charset)StandardCharsets.UTF_8);
            clientBuilder.proxyAuthenticator((route, resp) -> resp.request().newBuilder().header("Proxy-Authorization", basic).build());
        }
        return new BoxNetworkClient(clientBuilder.build());
    }

    @Override
    public FetchResponse fetch(FetchOptions options) {
        NetworkSession networkSession = options.getNetworkSession() == null ? new NetworkSession() : options.getNetworkSession();
        FetchOptions fetchOptions = networkSession.getInterceptors().stream().reduce(options, (modifiedOptions, interceptor) -> interceptor.beforeRequest((FetchOptions)modifiedOptions), (o1, o2) -> o2);
        boolean authenticationNeeded = false;
        FetchResponse fetchResponse = new FetchResponse.Builder(0, new TreeMap<String, String>()).build();
        Exception exceptionThrown = null;
        int attemptNumber = 1;
        int numberOfRetriesOnException = 0;
        int attemptForRetry = 0;
        boolean shouldRetry = false;
        while (true) {
            String rawResponseBody;
            Request request;
            block12: {
                request = BoxNetworkClient.prepareRequest(fetchOptions, authenticationNeeded, networkSession);
                Response response = null;
                rawResponseBody = null;
                try {
                    response = this.executeOnClient(request);
                    Map headersMap = response.headers().toMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0), (existing, replacement) -> existing, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
                    String responseUrl = response.networkResponse() != null ? response.networkResponse().request().url().toString() : response.request().url().toString();
                    attemptForRetry = attemptNumber;
                    if (Objects.equals(fetchOptions.getResponseFormat().getEnumValue(), ResponseFormat.BINARY)) {
                        fetchResponse = new FetchResponse.Builder(response.code(), headersMap).content(response.body().byteStream()).url(responseUrl).build();
                    } else {
                        rawResponseBody = response.body() != null ? response.body().string() : null;
                        fetchResponse = new FetchResponse.Builder(response.code(), headersMap).data(BoxNetworkClient.readJsonFromRawBody(rawResponseBody)).url(responseUrl).build();
                    }
                    fetchResponse = networkSession.getInterceptors().stream().reduce(fetchResponse, (modifiedResponse, interceptor) -> interceptor.afterRequest((FetchResponse)modifiedResponse), (o1, o2) -> o2);
                }
                catch (Exception e2) {
                    exceptionThrown = e2;
                    attemptForRetry = ++numberOfRetriesOnException;
                    if (response == null) break block12;
                    response.close();
                }
            }
            shouldRetry = networkSession.getRetryStrategy().shouldRetry(fetchOptions, fetchResponse, attemptForRetry);
            if (shouldRetry) {
                double retryDelay = networkSession.getRetryStrategy().retryAfter(fetchOptions, fetchResponse, attemptForRetry);
                if (retryDelay > 0.0) {
                    try {
                        TimeUnit.SECONDS.sleep((long)retryDelay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new BoxSDKError("Retry interrupted", ie);
                    }
                }
                ++attemptNumber;
                continue;
            }
            if (fetchResponse.getStatus() >= 300 && fetchResponse.getStatus() < 400 && fetchOptions.followRedirects.booleanValue()) {
                if (!fetchResponse.getHeaders().containsKey("Location")) {
                    throw new BoxSDKError("Redirect response missing Location header for " + fetchOptions.getUrl());
                }
                URI originalUri = URI.create(fetchOptions.getUrl());
                URI redirectUri = URI.create(fetchResponse.getHeaders().get("Location"));
                boolean sameOrigin = originalUri.getHost().equals(redirectUri.getHost()) && originalUri.getPort() == redirectUri.getPort() && originalUri.getScheme().equals(redirectUri.getScheme());
                return this.fetch(new FetchOptions.Builder(fetchResponse.getHeaders().get("Location"), "GET").responseFormat(fetchOptions.getResponseFormat()).auth(sameOrigin ? fetchOptions.getAuth() : null).networkSession(networkSession).build());
            }
            if (fetchResponse.getStatus() >= 200 && fetchResponse.getStatus() < 400) {
                return fetchResponse;
            }
            BoxNetworkClient.throwOnUnsuccessfulResponse(request, fetchResponse, rawResponseBody, exceptionThrown, networkSession.getDataSanitizer());
        }
    }

    private static Request prepareRequest(FetchOptions options, boolean reauthenticate, NetworkSession networkSession) {
        Request.Builder requestBuilder = new Request.Builder().url(options.getUrl());
        Headers headers = BoxNetworkClient.prepareHeaders(options, reauthenticate, networkSession);
        HttpUrl url = BoxNetworkClient.prepareUrl(options);
        RequestBody body = BoxNetworkClient.prepareRequestBody(options);
        requestBuilder.headers(headers);
        requestBuilder.url(url);
        requestBuilder.method(options.getMethod().toUpperCase(Locale.ROOT), body);
        return requestBuilder.build();
    }

    private static Headers prepareHeaders(FetchOptions options, boolean reauthenticate, NetworkSession networkSession) {
        Headers.Builder headersBuilder = new Headers.Builder();
        networkSession.getAdditionalHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).add(arg_0, arg_1));
        if (options.getHeaders() != null) {
            options.getHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).add(arg_0, arg_1));
        }
        if (options.getAuth() != null) {
            if (reauthenticate) {
                options.getAuth().refreshToken(networkSession);
            }
            headersBuilder.add("Authorization", options.getAuth().retrieveAuthorizationHeader(networkSession));
        }
        headersBuilder.add("User-Agent", BoxConstants.USER_AGENT_HEADER);
        headersBuilder.add("X-Box-UA", BoxConstants.X_BOX_UA_HEADER);
        return headersBuilder.build();
    }

    private static HttpUrl prepareUrl(FetchOptions options) {
        HttpUrl baseUrl = HttpUrl.parse((String)options.getUrl());
        if (baseUrl == null) {
            throw new IllegalArgumentException("Invalid URL " + options.getUrl());
        }
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder();
        if (options.getParams() != null) {
            options.getParams().forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        return urlBuilder.build();
    }

    private static RequestBody prepareRequestBody(FetchOptions options) {
        if (options.getMethod().equalsIgnoreCase("GET")) {
            return null;
        }
        String contentType = options.getContentType();
        MediaType mediaType = MediaType.parse((String)contentType);
        switch (contentType) {
            case "application/json": 
            case "application/json-patch+json": {
                return options.getData() != null ? RequestBody.create((String)JsonManager.sdToJson(options.getData()), (MediaType)mediaType) : RequestBody.create((String)"", (MediaType)mediaType);
            }
            case "application/x-www-form-urlencoded": {
                return options.getData() != null ? RequestBody.create((String)JsonManager.sdToUrlParams(options.getData()), (MediaType)mediaType) : RequestBody.create((String)"", (MediaType)mediaType);
            }
            case "multipart/form-data": {
                MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                for (MultipartItem part : options.multipartData) {
                    if (part.getData() != null) {
                        bodyBuilder.addFormDataPart(part.getPartName(), JsonManager.sdToJson(part.getData()));
                        continue;
                    }
                    bodyBuilder.addFormDataPart(part.getPartName(), part.getFileName() != null ? part.getFileName() : "file", BoxNetworkClient.createMultipartRequestBody(part));
                }
                return bodyBuilder.build();
            }
            case "application/octet-stream": {
                return RequestBody.create((byte[])UtilsManager.readByteStream(options.getFileStream()), (MediaType)mediaType);
            }
        }
        throw new IllegalArgumentException("Unsupported content type " + contentType);
    }

    protected Call createNewCall(Request request) {
        return this.httpClient.newCall(request);
    }

    private Response executeOnClient(Request request) throws IOException {
        return this.createNewCall(request).execute();
    }

    private static JsonNode readJsonFromRawBody(String rawResponseBody) {
        if (rawResponseBody == null) {
            return null;
        }
        try {
            return JsonManager.jsonToSerializedData(rawResponseBody);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void throwOnUnsuccessfulResponse(Request request, FetchResponse fetchResponse, String rawResponseBody, Exception exceptionThrown, DataSanitizer dataSanitizer) {
        if (fetchResponse.getStatus() == 0 && exceptionThrown != null) {
            throw new BoxSDKError(exceptionThrown.getMessage(), exceptionThrown);
        }
        try {
            throw BoxAPIError.fromAPICall(request, fetchResponse, rawResponseBody, dataSanitizer);
        }
        catch (Throwable throwable) {
            try {
                if (fetchResponse.getContent() != null) {
                    fetchResponse.getContent().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static int getRetryAfterTimeInSeconds(int attemptNumber, String retryAfterHeader) {
        if (retryAfterHeader != null) {
            return Integer.parseInt(retryAfterHeader);
        }
        double minWindow = 0.5;
        double maxWindow = 1.5;
        double jitter = Math.random() * (maxWindow - minWindow) + minWindow;
        return (int)(Math.pow(2.0, attemptNumber) * 1.0 * jitter);
    }

    public static RequestBody createMultipartRequestBody(final MultipartItem part) {
        return new RequestBody(){

            public MediaType contentType() {
                if (part.contentType != null) {
                    return MediaType.parse((String)part.contentType);
                }
                return MediaType.parse((String)"application/octet-stream");
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)part.getFileStream());){
                    sink.writeAll(source);
                }
            }
        };
    }
}

