/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.networking.network;

import com.box.sdkgen.box.errors.BoxSDKError;
import com.box.sdkgen.internal.logging.DataSanitizer;
import com.box.sdkgen.networking.baseurls.BaseUrls;
import com.box.sdkgen.networking.boxnetworkclient.BoxNetworkClient;
import com.box.sdkgen.networking.interceptors.Interceptor;
import com.box.sdkgen.networking.networkclient.NetworkClient;
import com.box.sdkgen.networking.proxyconfig.ProxyConfig;
import com.box.sdkgen.networking.retries.BoxRetryStrategy;
import com.box.sdkgen.networking.retries.RetryStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkSession {
    protected Map<String, String> additionalHeaders = new HashMap<String, String>();
    protected BaseUrls baseUrls = new BaseUrls();
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected NetworkClient networkClient;
    protected RetryStrategy retryStrategy;
    protected DataSanitizer dataSanitizer;
    protected ProxyConfig proxyConfig;

    public NetworkSession() {
        this.networkClient = new BoxNetworkClient();
        this.retryStrategy = new BoxRetryStrategy();
        this.dataSanitizer = new DataSanitizer();
    }

    protected NetworkSession(Builder builder) {
        this.additionalHeaders = builder.additionalHeaders;
        this.baseUrls = builder.baseUrls;
        this.networkClient = builder.networkClient;
        this.interceptors = builder.interceptors;
        this.retryStrategy = builder.retryStrategy;
        this.dataSanitizer = builder.dataSanitizer;
        this.proxyConfig = builder.proxyConfig;
    }

    public NetworkSession withAdditionalHeaders() {
        return this.withAdditionalHeaders(new HashMap<String, String>());
    }

    public NetworkSession withAdditionalHeaders(Map<String, String> additionalHeaders) {
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        newHeaders.putAll(this.additionalHeaders);
        newHeaders.putAll(additionalHeaders);
        return new Builder().additionalHeaders(newHeaders).baseUrls(this.baseUrls).interceptors(this.interceptors).networkClient(this.networkClient).retryStrategy(this.retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withCustomBaseUrls(BaseUrls baseUrls) {
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(baseUrls).interceptors(this.interceptors).networkClient(this.networkClient).retryStrategy(this.retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withInterceptors(List<Interceptor> interceptors) {
        List<Interceptor> newInterceptors = Stream.concat(this.interceptors.stream(), interceptors.stream()).collect(Collectors.toList());
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(this.baseUrls).interceptors(newInterceptors).networkClient(this.networkClient).retryStrategy(this.retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withNetworkClient(NetworkClient networkClient) {
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(this.baseUrls).interceptors(this.interceptors).networkClient(networkClient).retryStrategy(this.retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withRetryStrategy(RetryStrategy retryStrategy) {
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(this.baseUrls).interceptors(this.interceptors).networkClient(this.networkClient).retryStrategy(retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withDataSanitizer(DataSanitizer dataSanitizer) {
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(this.baseUrls).interceptors(this.interceptors).networkClient(this.networkClient).retryStrategy(this.retryStrategy).dataSanitizer(dataSanitizer).proxyConfig(this.proxyConfig).build();
    }

    public NetworkSession withProxy(ProxyConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("ProxyConfig cannot be null");
        }
        if (!(this.networkClient instanceof BoxNetworkClient)) {
            throw new BoxSDKError("Proxies are only supported for BoxNetworkClient");
        }
        BoxNetworkClient newClient = ((BoxNetworkClient)this.networkClient).withProxy(config);
        return new Builder().additionalHeaders(this.additionalHeaders).baseUrls(this.baseUrls).interceptors(this.interceptors).networkClient(newClient).retryStrategy(this.retryStrategy).dataSanitizer(this.dataSanitizer).proxyConfig(config).build();
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public BaseUrls getBaseUrls() {
        return this.baseUrls;
    }

    public NetworkClient getNetworkClient() {
        return this.networkClient;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public DataSanitizer getDataSanitizer() {
        return this.dataSanitizer;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public static class Builder {
        protected Map<String, String> additionalHeaders = new HashMap<String, String>();
        protected BaseUrls baseUrls = new BaseUrls();
        protected NetworkClient networkClient;
        protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
        protected RetryStrategy retryStrategy;
        protected DataSanitizer dataSanitizer;
        protected ProxyConfig proxyConfig;

        public Builder() {
            this.networkClient = new BoxNetworkClient();
            this.retryStrategy = new BoxRetryStrategy();
            this.dataSanitizer = new DataSanitizer();
        }

        public Builder additionalHeaders(Map<String, String> additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder baseUrls(BaseUrls baseUrls) {
            this.baseUrls = baseUrls;
            return this;
        }

        public Builder networkClient(NetworkClient networkClient) {
            this.networkClient = networkClient;
            return this;
        }

        public Builder interceptors(List<Interceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder dataSanitizer(DataSanitizer dataSanitizer) {
            this.dataSanitizer = dataSanitizer;
            return this;
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public NetworkSession build() {
            return new NetworkSession(this);
        }
    }
}

