/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.filerequest;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.filerequest.FileRequestStatusField;
import com.box.sdkgen.schemas.filerequest.FileRequestTypeField;
import com.box.sdkgen.schemas.foldermini.FolderMini;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class FileRequest
extends SerializableObject {
    protected final String id;
    @JsonDeserialize(using=FileRequestTypeField.FileRequestTypeFieldDeserializer.class)
    @JsonSerialize(using=FileRequestTypeField.FileRequestTypeFieldSerializer.class)
    protected EnumWrapper<FileRequestTypeField> type;
    protected String title;
    @Nullable
    protected String description;
    @JsonDeserialize(using=FileRequestStatusField.FileRequestStatusFieldDeserializer.class)
    @JsonSerialize(using=FileRequestStatusField.FileRequestStatusFieldSerializer.class)
    protected EnumWrapper<FileRequestStatusField> status;
    @JsonProperty(value="is_email_required")
    protected Boolean isEmailRequired;
    @JsonProperty(value="is_description_required")
    protected Boolean isDescriptionRequired;
    @JsonProperty(value="expires_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime expiresAt;
    protected final FolderMini folder;
    protected String url;
    @Nullable
    protected String etag;
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected final OffsetDateTime createdAt;
    @JsonProperty(value="updated_by")
    protected UserMini updatedBy;
    @JsonProperty(value="updated_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected final OffsetDateTime updatedAt;

    public FileRequest(@JsonProperty(value="id") String id, @JsonProperty(value="folder") FolderMini folder, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="updated_at") OffsetDateTime updatedAt) {
        this.id = id;
        this.folder = folder;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.type = new EnumWrapper<FileRequestTypeField>(FileRequestTypeField.FILE_REQUEST);
    }

    protected FileRequest(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.title = builder.title;
        this.description = builder.description;
        this.status = builder.status;
        this.isEmailRequired = builder.isEmailRequired;
        this.isDescriptionRequired = builder.isDescriptionRequired;
        this.expiresAt = builder.expiresAt;
        this.folder = builder.folder;
        this.url = builder.url;
        this.etag = builder.etag;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.updatedBy = builder.updatedBy;
        this.updatedAt = builder.updatedAt;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getId() {
        return this.id;
    }

    public EnumWrapper<FileRequestTypeField> getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public EnumWrapper<FileRequestStatusField> getStatus() {
        return this.status;
    }

    public Boolean getIsEmailRequired() {
        return this.isEmailRequired;
    }

    public Boolean getIsDescriptionRequired() {
        return this.isDescriptionRequired;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public FolderMini getFolder() {
        return this.folder;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEtag() {
        return this.etag;
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public UserMini getUpdatedBy() {
        return this.updatedBy;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRequest casted = (FileRequest)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.title, casted.title) && Objects.equals(this.description, casted.description) && Objects.equals(this.status, casted.status) && Objects.equals(this.isEmailRequired, casted.isEmailRequired) && Objects.equals(this.isDescriptionRequired, casted.isDescriptionRequired) && Objects.equals(this.expiresAt, casted.expiresAt) && Objects.equals(this.folder, casted.folder) && Objects.equals(this.url, casted.url) && Objects.equals(this.etag, casted.etag) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.updatedBy, casted.updatedBy) && Objects.equals(this.updatedAt, casted.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.title, this.description, this.status, this.isEmailRequired, this.isDescriptionRequired, this.expiresAt, this.folder, this.url, this.etag, this.createdBy, this.createdAt, this.updatedBy, this.updatedAt);
    }

    public String toString() {
        return "FileRequest{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", status='" + this.status + '\'' + ", isEmailRequired='" + this.isEmailRequired + '\'' + ", isDescriptionRequired='" + this.isDescriptionRequired + '\'' + ", expiresAt='" + this.expiresAt + '\'' + ", folder='" + this.folder + '\'' + ", url='" + this.url + '\'' + ", etag='" + this.etag + '\'' + ", createdBy='" + this.createdBy + '\'' + ", createdAt='" + this.createdAt + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", updatedAt='" + this.updatedAt + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected final String id;
        protected EnumWrapper<FileRequestTypeField> type;
        protected String title;
        protected String description;
        protected EnumWrapper<FileRequestStatusField> status;
        protected Boolean isEmailRequired;
        protected Boolean isDescriptionRequired;
        protected OffsetDateTime expiresAt;
        protected final FolderMini folder;
        protected String url;
        protected String etag;
        protected UserMini createdBy;
        protected final OffsetDateTime createdAt;
        protected UserMini updatedBy;
        protected final OffsetDateTime updatedAt;

        public Builder(String id, FolderMini folder, OffsetDateTime createdAt, OffsetDateTime updatedAt) {
            this.id = id;
            this.folder = folder;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.type = new EnumWrapper<FileRequestTypeField>(FileRequestTypeField.FILE_REQUEST);
        }

        public Builder type(FileRequestTypeField type) {
            this.type = new EnumWrapper<FileRequestTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<FileRequestTypeField> type) {
            this.type = type;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.markNullableFieldAsSet("description");
            return this;
        }

        public Builder status(FileRequestStatusField status) {
            this.status = new EnumWrapper<FileRequestStatusField>(status);
            return this;
        }

        public Builder status(EnumWrapper<FileRequestStatusField> status) {
            this.status = status;
            return this;
        }

        public Builder isEmailRequired(Boolean isEmailRequired) {
            this.isEmailRequired = isEmailRequired;
            return this;
        }

        public Builder isDescriptionRequired(Boolean isDescriptionRequired) {
            this.isDescriptionRequired = isDescriptionRequired;
            return this;
        }

        public Builder expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.markNullableFieldAsSet("etag");
            return this;
        }

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder updatedBy(UserMini updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public FileRequest build() {
            return new FileRequest(this);
        }
    }
}

