/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.oauth2error;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class OAuth2Error
extends SerializableObject {
    protected String error;
    @JsonProperty(value="error_description")
    protected String errorDescription;

    public OAuth2Error() {
    }

    protected OAuth2Error(Builder builder) {
        this.error = builder.error;
        this.errorDescription = builder.errorDescription;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Error casted = (OAuth2Error)o;
        return Objects.equals(this.error, casted.error) && Objects.equals(this.errorDescription, casted.errorDescription);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.errorDescription);
    }

    public String toString() {
        return "OAuth2Error{error='" + this.error + '\'' + ", errorDescription='" + this.errorDescription + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String error;
        protected String errorDescription;

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public OAuth2Error build() {
            return new OAuth2Error(this);
        }
    }
}

