/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.recentitem;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.filefull.FileFull;
import com.box.sdkgen.schemas.folderfull.FolderFull;
import com.box.sdkgen.schemas.recentitem.RecentItemInteractionTypeField;
import com.box.sdkgen.schemas.recentitemresource.RecentItemResource;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class RecentItem
extends SerializableObject {
    protected String type;
    protected RecentItemResource item;
    @JsonDeserialize(using=RecentItemInteractionTypeField.RecentItemInteractionTypeFieldDeserializer.class)
    @JsonSerialize(using=RecentItemInteractionTypeField.RecentItemInteractionTypeFieldSerializer.class)
    @JsonProperty(value="interaction_type")
    protected EnumWrapper<RecentItemInteractionTypeField> interactionType;
    @JsonProperty(value="interacted_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime interactedAt;
    @JsonProperty(value="interaction_shared_link")
    protected String interactionSharedLink;

    public RecentItem() {
    }

    protected RecentItem(Builder builder) {
        this.type = builder.type;
        this.item = builder.item;
        this.interactionType = builder.interactionType;
        this.interactedAt = builder.interactedAt;
        this.interactionSharedLink = builder.interactionSharedLink;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getType() {
        return this.type;
    }

    public RecentItemResource getItem() {
        return this.item;
    }

    public EnumWrapper<RecentItemInteractionTypeField> getInteractionType() {
        return this.interactionType;
    }

    public OffsetDateTime getInteractedAt() {
        return this.interactedAt;
    }

    public String getInteractionSharedLink() {
        return this.interactionSharedLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecentItem casted = (RecentItem)o;
        return Objects.equals(this.type, casted.type) && Objects.equals(this.item, casted.item) && Objects.equals(this.interactionType, casted.interactionType) && Objects.equals(this.interactedAt, casted.interactedAt) && Objects.equals(this.interactionSharedLink, casted.interactionSharedLink);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.item, this.interactionType, this.interactedAt, this.interactionSharedLink);
    }

    public String toString() {
        return "RecentItem{type='" + this.type + '\'' + ", item='" + this.item + '\'' + ", interactionType='" + this.interactionType + '\'' + ", interactedAt='" + this.interactedAt + '\'' + ", interactionSharedLink='" + this.interactionSharedLink + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String type;
        protected RecentItemResource item;
        protected EnumWrapper<RecentItemInteractionTypeField> interactionType;
        protected OffsetDateTime interactedAt;
        protected String interactionSharedLink;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder item(FileFull item) {
            this.item = new RecentItemResource(item);
            return this;
        }

        public Builder item(FolderFull item) {
            this.item = new RecentItemResource(item);
            return this;
        }

        public Builder item(WebLink item) {
            this.item = new RecentItemResource(item);
            return this;
        }

        public Builder item(RecentItemResource item) {
            this.item = item;
            return this;
        }

        public Builder interactionType(RecentItemInteractionTypeField interactionType) {
            this.interactionType = new EnumWrapper<RecentItemInteractionTypeField>(interactionType);
            return this;
        }

        public Builder interactionType(EnumWrapper<RecentItemInteractionTypeField> interactionType) {
            this.interactionType = interactionType;
            return this;
        }

        public Builder interactedAt(OffsetDateTime interactedAt) {
            this.interactedAt = interactedAt;
            return this;
        }

        public Builder interactionSharedLink(String interactionSharedLink) {
            this.interactionSharedLink = interactionSharedLink;
            return this;
        }

        public RecentItem build() {
            return new RecentItem(this);
        }
    }
}

