/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.DeveloperEditionEntityType;
import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.JWTEncryptionPreferences;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class BoxDeveloperEditionAPIConnection
extends BoxAPIConnection {
    private static final String JWT_AUDIENCE = "https://api.box.com/oauth2/token";
    private final String entityID;
    private final DeveloperEditionEntityType entityType;
    private final EncryptionAlgorithm encryptionAlgorithm;
    private final String publicKeyID;
    private final String privateKey;
    private final String privateKeyPassword;

    public BoxDeveloperEditionAPIConnection(String accessToken) {
        super(null);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    public BoxDeveloperEditionAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        super(null);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    public BoxDeveloperEditionAPIConnection(String clientID, String clientSecret, String authCode) {
        super(null);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    public BoxDeveloperEditionAPIConnection(String clientID, String clientSecret) {
        super(null);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    public BoxDeveloperEditionAPIConnection(String entityId, DeveloperEditionEntityType entityType, String clientID, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        super(clientID, clientSecret);
        this.entityID = entityId;
        this.entityType = entityType;
        this.publicKeyID = encryptionPref.getPublicKeyID();
        this.privateKey = encryptionPref.getPrivateKey();
        this.privateKeyPassword = encryptionPref.getPrivateKeyPassword();
        this.encryptionAlgorithm = encryptionPref.getEncryptionAlgorithm();
    }

    public static BoxDeveloperEditionAPIConnection getAppEnterpriseConnection(String enterpriseId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(enterpriseId, DeveloperEditionEntityType.ENTERPRISE, clientId, clientSecret, encryptionPref);
        connection.authenticate();
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppUserConnection(String userId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(userId, DeveloperEditionEntityType.USER, clientId, clientSecret, encryptionPref);
        connection.authenticate();
        return connection;
    }

    @Override
    public void authenticate(String authCode) {
        throw new BoxAPIException("BoxDeveloperEditionAPIConnection does not allow authenticating with an auth code.");
    }

    public void authenticate() {
        URL url = null;
        try {
            url = new URL(this.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        String jwtAssertion = this.constructJWTAssertion();
        String urlParameters = String.format("grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&client_id=%s&client_secret=%s&assertion=%s", this.getClientID(), this.getClientSecret(), jwtAssertion);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        String json = response.getJSON();
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.setAccessToken(jsonObject.get("access_token").asString());
        this.setLastRefresh(System.currentTimeMillis());
        this.setExpires(jsonObject.get("expires_in").asLong() * 1000L);
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    @Override
    public void refresh() {
        this.getRefreshLock().writeLock().lock();
        try {
            this.authenticate();
        }
        catch (BoxAPIException e) {
            this.notifyError(e);
            this.getRefreshLock().writeLock().unlock();
            throw e;
        }
        this.notifyRefresh();
        this.getRefreshLock().writeLock().unlock();
    }

    private String constructJWTAssertion() {
        String assertion;
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.getClientID());
        claims.setAudience(JWT_AUDIENCE);
        claims.setExpirationTimeMinutesInTheFuture(1.0f);
        claims.setSubject(this.entityID);
        claims.setClaim("box_sub_type", (Object)this.entityType.toString());
        claims.setGeneratedJwtId(64);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.decryptPrivateKey());
        jws.setAlgorithmHeaderValue(this.getAlgorithmIdentifier());
        jws.setHeader("typ", "JWT");
        if (this.publicKeyID != null && !this.publicKeyID.isEmpty()) {
            jws.setHeader("kid", this.publicKeyID);
        }
        try {
            assertion = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new BoxAPIException("Error serializing JSON Web Token assertion.", e);
        }
        return assertion;
    }

    private String getAlgorithmIdentifier() {
        String algorithmId = "RS256";
        switch (this.encryptionAlgorithm) {
            case RSA_SHA_384: {
                algorithmId = "RS384";
                break;
            }
            case RSA_SHA_512: {
                algorithmId = "RS512";
                break;
            }
        }
        return algorithmId;
    }

    private PrivateKey decryptPrivateKey() {
        PrivateKey decryptedPrivateKey;
        try {
            PEMParser keyReader = new PEMParser((Reader)new StringReader(this.privateKey));
            Object keyPair = keyReader.readObject();
            keyReader.close();
            if (keyPair instanceof PEMEncryptedKeyPair) {
                JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder();
                PEMDecryptorProvider decryptionProvider = builder.build(this.privateKeyPassword.toCharArray());
                keyPair = ((PEMEncryptedKeyPair)keyPair).decryptKeyPair(decryptionProvider);
            }
            PrivateKeyInfo keyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
            decryptedPrivateKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
        }
        catch (IOException e) {
            throw new BoxAPIException("Error parsing private key for Box Developer Edition.", e);
        }
        return decryptedPrivateKey;
    }
}

