/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.eclipsesource.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;

public class Representation {
    protected static final String X_REP_HINTS_PATTERN = "^(?:\\[[a-z0-9_]+(?:\\?[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*(?:&[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*)*)?(?:,[a-z0-9_]+(?:\\?[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*(?:&[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*)*)?)*\\])+$";
    private String representation;
    private JsonObject properties;
    private JsonObject metadata;
    private Info info;
    private Content content;
    private Status status;

    public Representation(JsonObject representationJson) {
        for (JsonObject.Member member : representationJson) {
            if (member.getName().equals("representation")) {
                this.representation = member.getValue().asString();
                continue;
            }
            if (member.getName().equals("properties")) {
                this.properties = member.getValue().asObject();
                continue;
            }
            if (member.getName().equals("metadata")) {
                this.metadata = member.getValue().asObject();
                continue;
            }
            if (member.getName().equals("info")) {
                this.info = new Info(member.getValue().asObject());
                continue;
            }
            if (member.getName().equals("content")) {
                this.content = new Content(member.getValue().asObject());
                continue;
            }
            if (!member.getName().equals("status")) continue;
            this.status = new Status(member.getValue().asObject());
        }
    }

    public String getRepresentation() {
        return this.representation;
    }

    public JsonObject getProperties() {
        return this.properties;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public Info getInfo() {
        return this.info;
    }

    public Content getContent() {
        return this.content;
    }

    public Status getStatus() {
        return this.status;
    }

    public class Status {
        private String state;

        public Status(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("state")) continue;
                this.state = member.getValue().asString();
            }
        }

        public String getState() {
            return this.state;
        }
    }

    public class Content {
        private String urlTemplate;

        public Content(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("url_template")) continue;
                this.urlTemplate = member.getValue().asString();
            }
        }

        public String getUrlTemplate() {
            return this.urlTemplate;
        }
    }

    public class Info {
        private URL url;

        public Info(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("url")) continue;
                try {
                    this.url = new URL(member.getValue().asString());
                }
                catch (MalformedURLException e) {
                    throw new BoxAPIException("Couldn't parse info.url for a file representation", e);
                }
            }
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

