/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnectionListener;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.RequestInterceptor;
import com.box.sdk.ScopedToken;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoxAPIConnection {
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final String AUTHORIZATION_URL = "https://account.box.com/api/oauth2/authorize";
    private static final String TOKEN_URL_STRING = "https://api.box.com/oauth2/token";
    private static final String REVOKE_URL_STRING = "https://api.box.com/oauth2/revoke";
    private static final String DEFAULT_BASE_URL = "https://api.box.com/2.0/";
    private static final String DEFAULT_BASE_UPLOAD_URL = "https://upload.box.com/api/2.0/";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String SDK_VERSION = "2.14.1";
    private static final long REFRESH_EPSILON = 60000L;
    private final String clientID;
    private final String clientSecret;
    private final ReadWriteLock refreshLock;
    private volatile long lastRefresh;
    private volatile long expires;
    private Proxy proxy;
    private String proxyUsername;
    private String proxyPassword;
    private String userAgent;
    private String accessToken;
    private String refreshToken;
    private String tokenURL;
    private String revokeURL;
    private String baseURL;
    private String baseUploadURL;
    private boolean autoRefresh;
    private int maxRequestAttempts;
    private List<BoxAPIConnectionListener> listeners;
    private RequestInterceptor interceptor;

    public BoxAPIConnection(String accessToken) {
        this(null, null, accessToken, null);
    }

    public BoxAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenURL = TOKEN_URL_STRING;
        this.revokeURL = REVOKE_URL_STRING;
        this.baseURL = DEFAULT_BASE_URL;
        this.baseUploadURL = DEFAULT_BASE_UPLOAD_URL;
        this.autoRefresh = true;
        this.maxRequestAttempts = 5;
        this.refreshLock = new ReentrantReadWriteLock();
        this.userAgent = "Box Java SDK v2.14.1 (Java " + JAVA_VERSION + ")";
        this.listeners = new ArrayList<BoxAPIConnectionListener>();
    }

    public BoxAPIConnection(String clientID, String clientSecret, String authCode) {
        this(clientID, clientSecret, null, null);
        this.authenticate(authCode);
    }

    public BoxAPIConnection(String clientID, String clientSecret) {
        this(clientID, clientSecret, null, null);
    }

    public BoxAPIConnection(BoxConfig boxConfig) {
        this(boxConfig.getClientId(), boxConfig.getClientSecret(), null, null);
    }

    public static BoxAPIConnection restore(String clientID, String clientSecret, String state) {
        BoxAPIConnection api = new BoxAPIConnection(clientID, clientSecret);
        api.restore(state);
        return api;
    }

    public static URL getAuthorizationURL(String clientID, URI redirectUri, String state, List<String> scopes) {
        URLTemplate template = new URLTemplate(AUTHORIZATION_URL);
        QueryStringBuilder queryBuilder = new QueryStringBuilder().appendParam("client_id", clientID).appendParam("response_type", "code").appendParam("redirect_uri", redirectUri.toString()).appendParam("state", state);
        if (scopes != null && !scopes.isEmpty()) {
            int i;
            StringBuilder builder = new StringBuilder();
            int size = scopes.size() - 1;
            for (i = 0; i < size; ++i) {
                builder.append(scopes.get(i));
                builder.append(" ");
            }
            builder.append(scopes.get(i));
            queryBuilder.appendParam("scope", builder.toString());
        }
        return template.buildWithQuery("", queryBuilder.toString(), new Object[0]);
    }

    public void authenticate(String authCode) {
        URL url = null;
        try {
            url = new URL(this.tokenURL);
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("grant_type=authorization_code&code=%s&client_id=%s&client_secret=%s", authCode, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        String json = response.getJSON();
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.accessToken = jsonObject.get("access_token").asString();
        this.refreshToken = jsonObject.get("refresh_token").asString();
        this.lastRefresh = System.currentTimeMillis();
        this.expires = jsonObject.get("expires_in").asLong() * 1000L;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setExpires(long milliseconds) {
        this.expires = milliseconds;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getTokenURL() {
        return this.tokenURL;
    }

    public void setTokenURL(String tokenURL) {
        this.tokenURL = tokenURL;
    }

    public void setRevokeURL(String url) {
        this.revokeURL = url;
    }

    public String getRevokeURL() {
        return this.revokeURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseUploadURL() {
        return this.baseUploadURL;
    }

    public void setBaseUploadURL(String baseUploadURL) {
        this.baseUploadURL = baseUploadURL;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getAccessToken() {
        if (this.autoRefresh && this.canRefresh() && this.needsRefresh()) {
            this.refreshLock.writeLock().lock();
            try {
                if (this.needsRefresh()) {
                    this.refresh();
                }
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    protected ReadWriteLock getRefreshLock() {
        return this.refreshLock;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public int getMaxRequestAttempts() {
        return this.maxRequestAttempts;
    }

    public void setMaxRequestAttempts(int attempts) {
        this.maxRequestAttempts = attempts;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean canRefresh() {
        return this.refreshToken != null;
    }

    public boolean needsRefresh() {
        this.refreshLock.readLock().lock();
        long now = System.currentTimeMillis();
        long tokenDuration = now - this.lastRefresh;
        boolean needsRefresh = tokenDuration >= this.expires - 60000L;
        this.refreshLock.readLock().unlock();
        return needsRefresh;
    }

    public void refresh() {
        String json;
        this.refreshLock.writeLock().lock();
        if (!this.canRefresh()) {
            this.refreshLock.writeLock().unlock();
            throw new IllegalStateException("The BoxAPIConnection cannot be refreshed because it doesn't have a refresh token.");
        }
        URL url = null;
        try {
            url = new URL(this.tokenURL);
        }
        catch (MalformedURLException e) {
            this.refreshLock.writeLock().unlock();
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("grant_type=refresh_token&refresh_token=%s&client_id=%s&client_secret=%s", this.refreshToken, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        try {
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            json = response.getJSON();
        }
        catch (BoxAPIException e) {
            this.notifyError(e);
            this.refreshLock.writeLock().unlock();
            throw e;
        }
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.accessToken = jsonObject.get("access_token").asString();
        this.refreshToken = jsonObject.get("refresh_token").asString();
        this.lastRefresh = System.currentTimeMillis();
        this.expires = jsonObject.get("expires_in").asLong() * 1000L;
        this.notifyRefresh();
        this.refreshLock.writeLock().unlock();
    }

    public void restore(String state) {
        JsonObject json = JsonObject.readFrom((String)state);
        String accessToken = json.get("accessToken").asString();
        String refreshToken = json.get("refreshToken").asString();
        long lastRefresh = json.get("lastRefresh").asLong();
        long expires = json.get("expires").asLong();
        String userAgent = json.get("userAgent").asString();
        String tokenURL = json.get("tokenURL").asString();
        String baseURL = json.get("baseURL").asString();
        String baseUploadURL = json.get("baseUploadURL").asString();
        boolean autoRefresh = json.get("autoRefresh").asBoolean();
        int maxRequestAttempts = json.get("maxRequestAttempts").asInt();
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.lastRefresh = lastRefresh;
        this.expires = expires;
        this.userAgent = userAgent;
        this.tokenURL = tokenURL;
        this.baseURL = baseURL;
        this.baseUploadURL = baseUploadURL;
        this.autoRefresh = autoRefresh;
        this.maxRequestAttempts = maxRequestAttempts;
    }

    protected void notifyRefresh() {
        for (BoxAPIConnectionListener listener : this.listeners) {
            listener.onRefresh(this);
        }
    }

    protected void notifyError(BoxAPIException error) {
        for (BoxAPIConnectionListener listener : this.listeners) {
            listener.onError(this, error);
        }
    }

    public void addListener(BoxAPIConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BoxAPIConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.interceptor;
    }

    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public ScopedToken getLowerScopedToken(List<String> scopes, String resource) {
        String json;
        assert (scopes != null);
        assert (scopes.size() > 0);
        URL url = null;
        try {
            url = new URL(this.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        StringBuilder spaceSeparatedScopes = new StringBuilder();
        for (int i = 0; i < scopes.size(); ++i) {
            spaceSeparatedScopes.append(scopes.get(i));
            if (i >= scopes.size() - 1) continue;
            spaceSeparatedScopes.append(" ");
        }
        String urlParameters = null;
        urlParameters = resource != null ? String.format("grant_type=urn:ietf:params:oauth:grant-type:token-exchange&subject_token_type=urn:ietf:params:oauth:token-type:access_token&subject_token=%s&scope=%s&resource=%s", this.getAccessToken(), spaceSeparatedScopes, resource) : String.format("grant_type=urn:ietf:params:oauth:grant-type:token-exchange&subject_token_type=urn:ietf:params:oauth:token-type:access_token&subject_token=%s&scope=%s", this.getAccessToken(), spaceSeparatedScopes);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        try {
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            json = response.getJSON();
        }
        catch (BoxAPIException e) {
            this.notifyError(e);
            throw e;
        }
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        ScopedToken token = new ScopedToken(jsonObject);
        token.setObtainedAt(System.currentTimeMillis());
        token.setExpiresIn(jsonObject.get("expires_in").asLong() * 1000L);
        return token;
    }

    public void revokeToken() {
        URL url = null;
        try {
            url = new URL(this.revokeURL);
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("token=%s&client_id=%s&client_secret=%s", this.accessToken, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        request.send();
    }

    public String save() {
        JsonObject state = new JsonObject().add("accessToken", this.accessToken).add("refreshToken", this.refreshToken).add("lastRefresh", this.lastRefresh).add("expires", this.expires).add("userAgent", this.userAgent).add("tokenURL", this.tokenURL).add("baseURL", this.baseURL).add("baseUploadURL", this.baseUploadURL).add("autoRefresh", this.autoRefresh).add("maxRequestAttempts", this.maxRequestAttempts);
        return state.toString();
    }

    String lockAccessToken() {
        if (this.autoRefresh && this.canRefresh() && this.needsRefresh()) {
            this.refreshLock.writeLock().lock();
            try {
                if (this.needsRefresh()) {
                    this.refresh();
                }
                this.refreshLock.readLock().lock();
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        } else {
            this.refreshLock.readLock().lock();
        }
        return this.accessToken;
    }

    void unlockAccessToken() {
        this.refreshLock.readLock().unlock();
    }

    String getBoxUAHeader() {
        return "agent=box-java-sdk/2.14.1; env=Java/" + JAVA_VERSION;
    }
}

