/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxJSONObject;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;

public class BoxSharedLink
extends BoxJSONObject {
    private String url;
    private String downloadUrl;
    private String vanityUrl;
    private boolean isPasswordEnabled;
    private Date unsharedAt;
    private long downloadCount;
    private long previewCount;
    private Access access;
    private Access effectiveAccess;
    private Permissions permissions;

    public BoxSharedLink() {
    }

    public BoxSharedLink(String json) {
        super(json);
    }

    BoxSharedLink(JsonObject jsonObject) {
        super(jsonObject);
    }

    BoxSharedLink(Access access, Date unshareDate, Permissions permissions) {
        this.setAccess(access);
        this.setPermissions(permissions);
        if (unshareDate != null) {
            this.setUnsharedDate(unshareDate);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getDownloadURL() {
        return this.downloadUrl;
    }

    public String getVanityURL() {
        return this.vanityUrl;
    }

    public boolean getIsPasswordEnabled() {
        return this.isPasswordEnabled;
    }

    public Date getUnsharedDate() {
        return this.unsharedAt;
    }

    public void setUnsharedDate(Date unsharedDate) {
        this.unsharedAt = unsharedDate;
        this.addPendingChange("unshared_at", unsharedDate.toString());
    }

    public long getDownloadCount() {
        return this.downloadCount;
    }

    public long getPreviewCount() {
        return this.previewCount;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
        this.addPendingChange("access", access.toJSONValue());
    }

    public Access getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        if (this.permissions == permissions) {
            return;
        }
        this.removeChildObject("permissions");
        this.permissions = permissions;
        this.addChildObject("permissions", permissions);
    }

    private Access parseAccessValue(JsonValue value) {
        String accessString = value.asString().toUpperCase();
        return Access.valueOf(accessString);
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        block23: {
            JsonValue value = member.getValue();
            try {
                String memberName = member.getName();
                if (memberName.equals("url")) {
                    this.url = value.asString();
                } else if (memberName.equals("download_url")) {
                    this.downloadUrl = value.asString();
                } else if (memberName.equals("vanity_url")) {
                    this.vanityUrl = value.asString();
                } else if (memberName.equals("is_password_enabled")) {
                    this.isPasswordEnabled = value.asBoolean();
                } else if (memberName.equals("unshared_at")) {
                    this.unsharedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("download_count")) {
                    this.downloadCount = Double.valueOf(value.toString()).longValue();
                } else if (memberName.equals("preview_count")) {
                    this.previewCount = Double.valueOf(value.toString()).longValue();
                } else if (memberName.equals("access")) {
                    this.access = this.parseAccessValue(value);
                } else if (memberName.equals("effective_access")) {
                    this.effectiveAccess = this.parseAccessValue(value);
                } else if (memberName.equals("permissions")) {
                    if (this.permissions == null) {
                        this.setPermissions(new Permissions(value.asObject()));
                    } else {
                        this.permissions.update(value.asObject());
                    }
                }
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block23;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
    }

    public static enum Access {
        DEFAULT(null),
        OPEN("open"),
        COMPANY("company"),
        COLLABORATORS("collaborators");

        private final String jsonValue;

        private Access(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static class Permissions
    extends BoxJSONObject {
        private boolean canDownload;
        private boolean canPreview;

        public Permissions() {
        }

        public Permissions(String json) {
            super(json);
        }

        Permissions(JsonObject jsonObject) {
            super(jsonObject);
        }

        public boolean getCanDownload() {
            return this.canDownload;
        }

        public void setCanDownload(boolean enabled) {
            this.canDownload = enabled;
            this.addPendingChange("can_download", enabled);
        }

        public boolean getCanPreview() {
            return this.canPreview;
        }

        public void setCanPreview(boolean enabled) {
            this.canPreview = enabled;
            this.addPendingChange("can_preview", enabled);
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("can_download")) {
                this.canDownload = value.asBoolean();
            } else if (memberName.equals("can_preview")) {
                this.canPreview = value.asBoolean();
            }
        }
    }
}

