/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxUser;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;

public class BoxLock
extends BoxJSONObject {
    private String type;
    private Date expiresAt;
    private Boolean isDownloadPrevented;
    private BoxUser.Info createdBy;
    private Date createdAt;
    private String id;
    private BoxAPIConnection api;

    public BoxLock(String type, Date expiresAt) {
        this.type = type;
        this.expiresAt = expiresAt;
        this.isDownloadPrevented = false;
    }

    public BoxLock(String type, Date expiresAt, Boolean isDownloadPrevented) {
        this.type = type;
        this.expiresAt = expiresAt;
        this.isDownloadPrevented = isDownloadPrevented;
    }

    BoxLock(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    public String getType() {
        return this.type;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public Boolean getIsDownloadPrevented() {
        return this.isDownloadPrevented;
    }

    public BoxUser.Info getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block15: {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("type")) {
                    this.type = value.asString();
                } else if (memberName.equals("expires_at")) {
                    this.expiresAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("is_download_prevented")) {
                    this.isDownloadPrevented = value.asBoolean();
                } else if (memberName.equals("created_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(this.api, userID);
                        boxUser.getClass();
                        this.createdBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("id")) {
                    this.id = value.toString();
                }
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
    }
}

