/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class MetadataTemplate
extends BoxJSONObject {
    private static final URLTemplate METADATA_TEMPLATE_URL_TEMPLATE = new URLTemplate("metadata_templates/%s/%s/schema");
    private static final URLTemplate ENTERPRISE_METADATA_URL_TEMPLATE = new URLTemplate("metadata_templates/%s");
    private static final String DEFAULT_METADATA_TYPE = "properties";
    private static final String GLOBAL_METADATA_SCOPE = "global";
    private static final String ENTERPRISE_METADATA_SCOPE = "enterprise";
    private static final int DEFAULT_ENTRIES_LIMIT = 100;
    private String templateKey;
    private String scope;
    private String displayName;
    private Boolean isHidden;
    private List<Field> fields;

    public MetadataTemplate() {
    }

    public MetadataTemplate(String json) {
        super(json);
    }

    MetadataTemplate(JsonObject jsonObject) {
        super(jsonObject);
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        if (memberName.equals("templateKey")) {
            this.templateKey = value.asString();
        } else if (memberName.equals("scope")) {
            this.scope = value.asString();
        } else if (memberName.equals("displayName")) {
            this.displayName = value.asString();
        } else if (memberName.equals("hidden")) {
            this.isHidden = value.asBoolean();
        } else if (memberName.equals("fields")) {
            this.fields = new ArrayList<Field>();
            for (JsonValue field : value.asArray()) {
                this.fields.add(new Field(field.asObject()));
            }
        }
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api) {
        return MetadataTemplate.getMetadataTemplate(api, DEFAULT_METADATA_TYPE);
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api, String templateName) {
        String scope = MetadataTemplate.scopeBasedOnType(templateName);
        return MetadataTemplate.getMetadataTemplate(api, templateName, scope, new String[0]);
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api, String templateName, String scope, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = METADATA_TEMPLATE_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new MetadataTemplate(response.getJSON());
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(BoxAPIConnection api, String ... fields) {
        return MetadataTemplate.getEnterpriseMetadataTemplates(ENTERPRISE_METADATA_SCOPE, api, fields);
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(String scope, BoxAPIConnection api, String ... fields) {
        return MetadataTemplate.getEnterpriseMetadataTemplates(ENTERPRISE_METADATA_SCOPE, 100, api, fields);
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(String scope, int limit, BoxAPIConnection api, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<MetadataTemplate>(api, ENTERPRISE_METADATA_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), scope), limit){

            @Override
            protected MetadataTemplate factory(JsonObject jsonObject) {
                return new MetadataTemplate(jsonObject);
            }
        };
    }

    private static String scopeBasedOnType(String typeName) {
        return typeName.equals(DEFAULT_METADATA_TYPE) ? GLOBAL_METADATA_SCOPE : ENTERPRISE_METADATA_SCOPE;
    }

    public class Field
    extends BoxJSONObject {
        private String type;
        private String key;
        private String displayName;
        private Boolean isHidden;
        private String description;
        private List<String> options;

        public Field() {
        }

        public Field(String json) {
            super(json);
        }

        Field(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Boolean getIsHidden() {
            return this.isHidden;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getOptions() {
            return this.options;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("type")) {
                this.type = value.asString();
            } else if (memberName.equals("key")) {
                this.key = value.asString();
            } else if (memberName.equals("displayName")) {
                this.displayName = value.asString();
            } else if (memberName.equals("hidden")) {
                this.isHidden = value.asBoolean();
            } else if (memberName.equals("description")) {
                this.description = value.asString();
            } else if (memberName.equals("options")) {
                this.options = new ArrayList<String>();
                for (JsonValue key : value.asArray()) {
                    this.options.add(key.asObject().get("key").asString());
                }
            }
        }
    }
}

