/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxStoragePolicyAssignment;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.net.URL;

@BoxResourceType(value="storage_policy")
public class BoxStoragePolicy
extends BoxResource {
    public static final URLTemplate STORAGE_POLICY_URL_TEMPLATE = new URLTemplate("storage_policies");
    public static final URLTemplate STORAGE_POLICY_WITH_ID_URL_TEMPLATE = new URLTemplate("storage_policies/%s");
    private static final int DEFAULT_LIMIT = 100;

    public BoxStoragePolicy(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = STORAGE_POLICY_WITH_ID_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxStoragePolicy.getAll(api, 100, fields);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = STORAGE_POLICY_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxStoragePolicy storagePolicy;
                BoxStoragePolicy boxStoragePolicy = storagePolicy = new BoxStoragePolicy(api, jsonObject.get("id").asString());
                boxStoragePolicy.getClass();
                return boxStoragePolicy.new Info(jsonObject);
            }
        };
    }

    public BoxStoragePolicyAssignment.Info assign(String userID) {
        return BoxStoragePolicyAssignment.assign(this.getAPI(), this.getID(), userID);
    }

    public class Info
    extends BoxResource.Info {
        private String storagePolicyName;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxStoragePolicy getResource() {
            return BoxStoragePolicy.this;
        }

        public String getStoragePolicyName() {
            return this.storagePolicyName;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block3: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("name")) {
                        this.storagePolicyName = value.asString();
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

