/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxLegalHoldAssignment;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="file_version_legal_hold")
public class BoxFileVersionLegalHold
extends BoxResource {
    public static final URLTemplate FILE_VERSION_HOLD_URL_TEMPLATE = new URLTemplate("file_version_legal_holds/%s");

    public BoxFileVersionLegalHold(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = FILE_VERSION_HOLD_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public class Info
    extends BoxResource.Info {
        private static final String DEFAULT_FILE_ID = "0";
        private BoxFileVersion fileVersion;
        private BoxFile.Info file;
        private List<BoxLegalHoldAssignment.Info> assignments;
        private Date deletedAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxFileVersionLegalHold.this;
        }

        public BoxFileVersion getFileVersion() {
            return this.fileVersion;
        }

        public BoxFile.Info getFile() {
            return this.file;
        }

        public Iterable<BoxLegalHoldAssignment.Info> getAssignments() {
            return this.assignments;
        }

        public Date getDeletedAt() {
            return this.deletedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block13: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("file")) {
                        JsonObject fileJSON = value.asObject();
                        if (this.file == null) {
                            BoxFile file;
                            String fileID = fileJSON.get("id").asString();
                            BoxFile boxFile = file = new BoxFile(BoxFileVersionLegalHold.this.getAPI(), fileID);
                            boxFile.getClass();
                            this.file = boxFile.new BoxFile.Info(fileJSON);
                        } else {
                            this.file.update(fileJSON);
                        }
                        if (this.fileVersion != null) {
                            this.fileVersion.setFileID(this.file.getID());
                        }
                    } else if (memberName.equals("file_version")) {
                        JsonObject versionJSON = value.asObject();
                        String fileID = this.file != null ? this.file.getID() : DEFAULT_FILE_ID;
                        this.fileVersion = new BoxFileVersion(BoxFileVersionLegalHold.this.getAPI(), versionJSON, fileID);
                    } else if (memberName.equals("legal_hold_policy_assignments")) {
                        JsonArray array = value.asArray();
                        this.assignments = new ArrayList<BoxLegalHoldAssignment.Info>();
                        for (JsonValue assignmentJSON : array) {
                            BoxLegalHoldAssignment assignment;
                            String assignmentID = ((JsonObject)assignmentJSON).get("id").asString();
                            BoxLegalHoldAssignment boxLegalHoldAssignment = assignment = new BoxLegalHoldAssignment(BoxFileVersionLegalHold.this.getAPI(), assignmentID);
                            boxLegalHoldAssignment.getClass();
                            this.assignments.add(boxLegalHoldAssignment.new BoxLegalHoldAssignment.Info((JsonObject)assignmentJSON));
                        }
                    } else if (memberName.equals("deleted_at")) {
                        this.deletedAt = BoxDateFormat.parse(value.asString());
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

