/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxTaskAssignment;
import com.box.sdk.BoxTaskAssignmentIterator;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@BoxResourceType(value="task")
public class BoxTask
extends BoxResource {
    public static final URLTemplate TASK_URL_TEMPLATE = new URLTemplate("tasks/%s");
    public static final URLTemplate GET_ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("tasks/%s/assignments");
    public static final URLTemplate ADD_TASK_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("task_assignments");

    public BoxTask(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public void delete() {
        URL url = TASK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public BoxTaskAssignment.Info addAssignment(BoxUser assignTo) {
        BoxTaskAssignment addedAssignment;
        JsonObject taskJSON = new JsonObject();
        taskJSON.add("type", "task");
        taskJSON.add("id", this.getID());
        JsonObject assignToJSON = new JsonObject();
        assignToJSON.add("id", assignTo.getID());
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("task", (JsonValue)taskJSON);
        requestJSON.add("assign_to", (JsonValue)assignToJSON);
        URL url = ADD_TASK_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxTaskAssignment boxTaskAssignment = addedAssignment = new BoxTaskAssignment(this.getAPI(), responseJSON.get("id").asString());
        boxTaskAssignment.getClass();
        return boxTaskAssignment.new BoxTaskAssignment.Info(responseJSON);
    }

    public BoxTaskAssignment.Info addAssignmentByLogin(String assignToLogin) {
        BoxTaskAssignment addedAssignment;
        JsonObject taskJSON = new JsonObject();
        taskJSON.add("type", "task");
        taskJSON.add("id", this.getID());
        JsonObject assignToJSON = new JsonObject();
        assignToJSON.add("login", assignToLogin);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("task", (JsonValue)taskJSON);
        requestJSON.add("assign_to", (JsonValue)assignToJSON);
        URL url = ADD_TASK_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxTaskAssignment boxTaskAssignment = addedAssignment = new BoxTaskAssignment(this.getAPI(), responseJSON.get("id").asString());
        boxTaskAssignment.getClass();
        return boxTaskAssignment.new BoxTaskAssignment.Info(responseJSON);
    }

    public List<BoxTaskAssignment.Info> getAssignments() {
        URL url = GET_ASSIGNMENTS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int totalCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxTaskAssignment.Info> assignments = new ArrayList<BoxTaskAssignment.Info>(totalCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue value : entries) {
            BoxTaskAssignment assignment;
            JsonObject assignmentJSON = value.asObject();
            BoxTaskAssignment boxTaskAssignment = assignment = new BoxTaskAssignment(this.getAPI(), assignmentJSON.get("id").asString());
            boxTaskAssignment.getClass();
            BoxTaskAssignment.Info info = boxTaskAssignment.new BoxTaskAssignment.Info(assignmentJSON);
            assignments.add(info);
        }
        return assignments;
    }

    public Iterable<BoxTaskAssignment.Info> getAllAssignments(String ... fields) {
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<BoxTaskAssignment.Info>(){

            @Override
            public Iterator<BoxTaskAssignment.Info> iterator() {
                URL url = GET_ASSIGNMENTS_URL_TEMPLATE.buildWithQuery(BoxTask.this.getAPI().getBaseURL(), builder.toString(), BoxTask.this.getID());
                return new BoxTaskAssignmentIterator(BoxTask.this.getAPI(), url);
            }
        };
    }

    public Info getInfo() {
        URL url = TASK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = TASK_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public void updateInfo(Info info) {
        URL url = TASK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public static enum Action {
        REVIEW("review");

        private final String jsonValue;

        private Action(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Action fromJSONString(String jsonValue) {
            if (jsonValue.equals("review")) {
                return REVIEW;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid Action.");
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public class Info
    extends BoxResource.Info {
        private BoxFile.Info item;
        private Date dueAt;
        private String action;
        private String message;
        private List<BoxTaskAssignment.Info> taskAssignments;
        private boolean completed;
        private BoxUser.Info createdBy;
        private Date createdAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxTask getResource() {
            return BoxTask.this;
        }

        public BoxFile.Info getItem() {
            return this.item;
        }

        public Date getDueAt() {
            return this.dueAt;
        }

        public void setDueAt(Date dueAt) {
            this.dueAt = dueAt;
            this.addPendingChange("due_at", BoxDateFormat.format(dueAt));
        }

        @Deprecated
        public Action getAction() {
            return Action.REVIEW;
        }

        public String getTaskType() {
            return this.action;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
            this.addPendingChange("message", message);
        }

        public List<BoxTaskAssignment.Info> getTaskAssignments() {
            return this.taskAssignments;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("item")) {
                    BoxFile file;
                    JsonObject itemJSON = value.asObject();
                    String itemID = itemJSON.get("id").asString();
                    BoxFile boxFile = file = new BoxFile(BoxTask.this.getAPI(), itemID);
                    boxFile.getClass();
                    this.item = boxFile.new BoxFile.Info(itemJSON);
                } else if (memberName.equals("due_at")) {
                    this.dueAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("action")) {
                    this.action = value.asString();
                } else if (memberName.equals("message")) {
                    this.message = value.asString();
                } else if (memberName.equals("task_assignment_collection")) {
                    this.taskAssignments = this.parseTaskAssignmentCollection(value.asObject());
                } else if (memberName.equals("is_completed")) {
                    this.completed = value.asBoolean();
                } else if (memberName.equals("created_by")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxTask.this.getAPI(), userID);
                    boxUser.getClass();
                    this.createdBy = boxUser.new BoxUser.Info(userJSON);
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private List<BoxTaskAssignment.Info> parseTaskAssignmentCollection(JsonObject jsonObject) {
            int count = jsonObject.get("total_count").asInt();
            ArrayList<BoxTaskAssignment.Info> taskAssignmentCollection = new ArrayList<BoxTaskAssignment.Info>(count);
            JsonArray entries = jsonObject.get("entries").asArray();
            for (JsonValue value : entries) {
                BoxTaskAssignment assignment;
                JsonObject entry = value.asObject();
                String id = entry.get("id").asString();
                BoxTaskAssignment boxTaskAssignment = assignment = new BoxTaskAssignment(BoxTask.this.getAPI(), id);
                boxTaskAssignment.getClass();
                taskAssignmentCollection.add(boxTaskAssignment.new BoxTaskAssignment.Info(entry));
            }
            return taskAssignmentCollection;
        }
    }
}

