/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxResource;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;

public abstract class BoxCollaborator
extends BoxResource {
    public BoxCollaborator(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public abstract class Info
    extends BoxResource.Info {
        private String name;
        private Date createdAt;
        private Date modifiedAt;
        private String login;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.addPendingChange("name", name);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public String getLogin() {
            return this.login;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String name = member.getName();
            try {
                if (name.equals("name")) {
                    this.name = value.asString();
                } else if (name.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (name.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (name.equals("login")) {
                    this.login = value.asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(name, value.toString(), e);
            }
        }
    }
}

