/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BackoffCounter;
import com.box.sdk.Base64;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxRedirectResponse;
import com.box.sdk.ProgressListener;
import com.box.sdk.ProgressOutputStream;
import com.box.sdk.RequestInterceptor;
import com.box.sdk.SharedLinkAPIConnection;
import com.box.sdk.StandardCharsets;
import com.box.sdk.Time;
import com.box.sdk.http.HttpMethod;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoxAPIRequest {
    private static final Logger LOGGER = Logger.getLogger(BoxAPIRequest.class.getName());
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_REDIRECTS = 3;
    private final BoxAPIConnection api;
    private final List<RequestHeader> headers;
    private final String method;
    private URL url;
    private BackoffCounter backoffCounter;
    private int timeout;
    private InputStream body;
    private long bodyLength;
    private Map<String, List<String>> requestProperties;
    private int numRedirects;
    private boolean followRedirects = true;
    private boolean shouldAuthenticate;

    public BoxAPIRequest(URL url, String method) {
        this(null, url, method);
    }

    public BoxAPIRequest(BoxAPIConnection api, URL url, String method) {
        this.api = api;
        this.url = url;
        this.method = method;
        this.headers = new ArrayList<RequestHeader>();
        this.backoffCounter = new BackoffCounter(new Time());
        this.shouldAuthenticate = true;
        this.addHeader("Accept-Encoding", "gzip");
        this.addHeader("Accept-Charset", "utf-8");
    }

    public BoxAPIRequest(BoxAPIConnection api, URL uploadPartEndpoint, HttpMethod method) {
        this(api, uploadPartEndpoint, method.name());
    }

    public void addHeader(String key, String value) {
        this.headers.add(new RequestHeader(key, value));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public InputStream getBody() {
        return this.body;
    }

    public void setBody(InputStream stream) {
        this.body = stream;
    }

    public void setBody(InputStream stream, long length) {
        this.bodyLength = length;
        this.body = stream;
    }

    public void setBody(String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        this.bodyLength = bytes.length;
        this.body = new ByteArrayInputStream(bytes);
    }

    public URL getUrl() {
        return this.url;
    }

    public BoxAPIResponse send() {
        return this.send(null);
    }

    public BoxAPIResponse send(ProgressListener listener) {
        if (this.api == null) {
            this.backoffCounter.reset(3);
        } else {
            this.backoffCounter.reset(this.api.getMaxRequestAttempts());
        }
        while (this.backoffCounter.getAttemptsRemaining() > 0) {
            try {
                return this.trySend(listener);
            }
            catch (BoxAPIException apiException) {
                if (!this.backoffCounter.decrement() || !BoxAPIRequest.isResponseRetryable(apiException.getResponseCode())) {
                    throw apiException;
                }
                try {
                    this.resetBody();
                }
                catch (IOException ioException) {
                    throw apiException;
                }
                try {
                    this.backoffCounter.waitBackoff();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw apiException;
                }
            }
        }
        throw new RuntimeException();
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Request");
        builder.append(lineSeparator);
        builder.append(this.method);
        builder.append(' ');
        builder.append(this.url.toString());
        builder.append(lineSeparator);
        for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
            ArrayList<String> nonEmptyValues = new ArrayList<String>();
            for (String value : entry.getValue()) {
                if (value == null || value.trim().length() == 0) continue;
                nonEmptyValues.add(value);
            }
            if (nonEmptyValues.size() == 0) continue;
            builder.append(entry.getKey());
            builder.append(": ");
            for (String value : nonEmptyValues) {
                builder.append(value);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            builder.append(lineSeparator);
        }
        String bodyString = this.bodyToString();
        if (bodyString != null) {
            builder.append(lineSeparator);
            builder.append(bodyString);
        }
        return builder.toString().trim();
    }

    protected String bodyToString() {
        return null;
    }

    protected void writeBody(HttpURLConnection connection, ProgressListener listener) {
        if (this.body == null) {
            return;
        }
        connection.setDoOutput(true);
        try {
            OutputStream output = connection.getOutputStream();
            if (listener != null) {
                output = new ProgressOutputStream(output, listener, this.bodyLength);
            }
            int b = this.body.read();
            while (b != -1) {
                output.write(b);
                b = this.body.read();
            }
            output.close();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
    }

    protected void resetBody() throws IOException {
        if (this.body != null) {
            this.body.reset();
        }
    }

    void setBackoffCounter(BackoffCounter counter) {
        this.backoffCounter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoxAPIResponse trySend(ProgressListener listener) {
        int responseCode;
        BoxAPIResponse response;
        RequestInterceptor interceptor;
        if (this.api != null && (interceptor = this.api.getRequestInterceptor()) != null && (response = interceptor.onRequest(this)) != null) {
            return response;
        }
        HttpURLConnection connection = this.createConnection();
        if (this.bodyLength > 0L) {
            connection.setFixedLengthStreamingMode((int)this.bodyLength);
            connection.setDoOutput(true);
        }
        if (this.api != null) {
            if (this.shouldAuthenticate) {
                connection.addRequestProperty("Authorization", "Bearer " + this.api.lockAccessToken());
            }
            connection.setRequestProperty("User-Agent", this.api.getUserAgent());
            if (this.api.getProxy() != null && this.api.getProxyUsername() != null && this.api.getProxyPassword() != null) {
                String usernameAndPassword = this.api.getProxyUsername() + ":" + this.api.getProxyPassword();
                String encoded = new String(Base64.encode(usernameAndPassword.getBytes()));
                connection.addRequestProperty("Proxy-Authorization", "Basic " + encoded);
            }
            if (this.api instanceof SharedLinkAPIConnection) {
                SharedLinkAPIConnection sharedItemAPI = (SharedLinkAPIConnection)this.api;
                String sharedLink = sharedItemAPI.getSharedLink();
                String boxAPIValue = "shared_link=" + sharedLink;
                String sharedLinkPassword = sharedItemAPI.getSharedLinkPassword();
                if (sharedLinkPassword != null) {
                    boxAPIValue = boxAPIValue + "&shared_link_password=" + sharedLinkPassword;
                }
                connection.addRequestProperty("BoxApi", boxAPIValue);
            }
        }
        this.requestProperties = connection.getRequestProperties();
        try {
            this.writeBody(connection, listener);
            try {
                connection.connect();
            }
            catch (IOException e) {
                throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
            }
            this.logRequest(connection);
            try {
                responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
            }
        }
        finally {
            if (this.api != null && this.shouldAuthenticate) {
                this.api.unlockAccessToken();
            }
        }
        if (BoxAPIRequest.isResponseRedirect(responseCode)) {
            return this.handleRedirect(connection, listener);
        }
        String contentType = connection.getContentType();
        BoxAPIResponse response2 = contentType == null ? new BoxAPIResponse(connection) : (contentType.contains("application/json") ? new BoxJSONResponse(connection) : new BoxAPIResponse(connection));
        return response2;
    }

    private BoxAPIResponse handleRedirect(HttpURLConnection connection, ProgressListener listener) {
        if (this.numRedirects >= 3) {
            throw new BoxAPIException("The Box API responded with too many redirects.");
        }
        ++this.numRedirects;
        try {
            InputStream stream = connection.getInputStream();
            byte[] buffer = new byte[8192];
            int n = stream.read(buffer);
            while (n != -1) {
                n = stream.read(buffer);
            }
            stream.close();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        String redirect = connection.getHeaderField("Location");
        try {
            this.url = new URL(redirect);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("The Box API responded with an invalid redirect.", e);
        }
        if (this.followRedirects) {
            return this.trySend(listener);
        }
        BoxRedirectResponse redirectResponse = new BoxRedirectResponse();
        redirectResponse.setRedirectURL(this.url);
        return redirectResponse;
    }

    private void logRequest(HttpURLConnection connection) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, this.toString());
        }
    }

    private HttpURLConnection createConnection() {
        HttpURLConnection connection = null;
        try {
            connection = this.api == null || this.api.getProxy() == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.api.getProxy());
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new BoxAPIException("Couldn't connect to the Box API because the request's method was invalid.", e);
        }
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setInstanceFollowRedirects(false);
        for (RequestHeader header : this.headers) {
            connection.addRequestProperty(header.getKey(), header.getValue());
        }
        return connection;
    }

    void shouldAuthenticate(boolean shouldAuthenticate) {
        this.shouldAuthenticate = shouldAuthenticate;
    }

    private static boolean isResponseRetryable(int responseCode) {
        return responseCode >= 500 || responseCode == 429;
    }

    private static boolean isResponseRedirect(int responseCode) {
        return responseCode == 301 || responseCode == 302;
    }

    private final class RequestHeader {
        private final String key;
        private final String value;

        public RequestHeader(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

