/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.ProgressInputStream;
import com.box.sdk.ProgressListener;
import com.box.sdk.StandardCharsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class BoxAPIResponse {
    private static final Logger LOGGER = Logger.getLogger(BoxAPIResponse.class.getName());
    private static final int BUFFER_SIZE = 8192;
    private final HttpURLConnection connection;
    private int responseCode;
    private String bodyString;
    private InputStream rawInputStream;
    private InputStream inputStream;

    public BoxAPIResponse() {
        this.connection = null;
    }

    public BoxAPIResponse(HttpURLConnection connection) {
        this.connection = connection;
        this.inputStream = null;
        try {
            this.responseCode = this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        if (!BoxAPIResponse.isSuccess(this.responseCode)) {
            this.logResponse();
            throw new BoxAPIException("The API returned an error code: " + this.responseCode, this.responseCode, this.bodyToString());
        }
        this.logResponse();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getContentLength() {
        return this.connection.getContentLength();
    }

    public String getHeaderField(String fieldName) {
        return this.connection.getHeaderField(fieldName);
    }

    public InputStream getBody() {
        return this.getBody(null);
    }

    public InputStream getBody(ProgressListener listener) {
        if (this.inputStream == null) {
            String contentEncoding = this.connection.getContentEncoding();
            try {
                if (this.rawInputStream == null) {
                    this.rawInputStream = this.connection.getInputStream();
                }
                this.inputStream = listener == null ? this.rawInputStream : new ProgressInputStream(this.rawInputStream, listener, this.getContentLength());
                if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                    this.inputStream = new GZIPInputStream(this.inputStream);
                }
            }
            catch (IOException e) {
                throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
            }
        }
        return this.inputStream;
    }

    public void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            if (this.rawInputStream == null) {
                this.rawInputStream = this.connection.getInputStream();
            }
            byte[] buffer = new byte[8192];
            int n = this.rawInputStream.read(buffer);
            while (n != -1) {
                n = this.rawInputStream.read(buffer);
            }
            this.rawInputStream.close();
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't finish closing the connection to the Box API due to a network error or because the stream was already closed.", e);
        }
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        Map<String, List<String>> headers = this.connection.getHeaderFields();
        StringBuilder builder = new StringBuilder();
        builder.append("Response");
        builder.append(lineSeparator);
        builder.append(this.connection.getRequestMethod());
        builder.append(' ');
        builder.append(this.connection.getURL().toString());
        builder.append(lineSeparator);
        builder.append(headers.get(null).get(0));
        builder.append(lineSeparator);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            ArrayList<String> nonEmptyValues = new ArrayList<String>();
            for (String value : entry.getValue()) {
                if (value == null || value.trim().length() == 0) continue;
                nonEmptyValues.add(value);
            }
            if (nonEmptyValues.size() == 0) continue;
            builder.append(key);
            builder.append(": ");
            for (String value : nonEmptyValues) {
                builder.append(value);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            builder.append(lineSeparator);
        }
        String bodyString = this.bodyToString();
        if (bodyString != null && bodyString != "") {
            builder.append(lineSeparator);
            builder.append(bodyString);
        }
        return builder.toString().trim();
    }

    protected String bodyToString() {
        if (this.bodyString == null && !BoxAPIResponse.isSuccess(this.responseCode)) {
            this.bodyString = BoxAPIResponse.readErrorStream(this.getErrorStream());
        }
        return this.bodyString;
    }

    private InputStream getErrorStream() {
        String contentEncoding;
        InputStream errorStream = this.connection.getErrorStream();
        if (errorStream != null && (contentEncoding = this.connection.getContentEncoding()) != null && contentEncoding.equalsIgnoreCase("gzip")) {
            try {
                errorStream = new GZIPInputStream(errorStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return errorStream;
    }

    private void logResponse() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, this.toString());
        }
    }

    private static boolean isSuccess(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private static String readErrorStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int read = reader.read(buffer, 0, 8192);
            while (read != -1) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer, 0, 8192);
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        return builder.toString();
    }
}

