/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class URLTemplate {
    private static final Pattern NUMERIC = Pattern.compile("^[0-9]*$");
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[a-zA-Z0-9!@#$%^&*()_+\\-]*$");
    private String template;

    public URLTemplate(String template) {
        this.template = template;
    }

    public URL build(String base, Object ... values) {
        URL url;
        block4: {
            for (Object value : values) {
                String valueString = String.valueOf(value);
                Boolean test = NUMERIC.matcher(valueString).matches();
                if (!NUMERIC.matcher(valueString).matches()) assert (false) : "An invalid path parameter passed in. It must be numeric.";
            }
            String urlString = String.format(base + this.template, values);
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"A valid URL could not be constructed from the provided parameters.");
            }
        }
        return url;
    }

    public URL buildAlpha(String base, Object ... values) {
        URL url;
        block4: {
            for (Object value : values) {
                String valueString = String.valueOf(value);
                Boolean test = ALPHA_NUMERIC.matcher(valueString).matches();
                if (!ALPHA_NUMERIC.matcher(valueString).matches()) assert (false) : "An invalid path parameter passed in. It must be alphanumeric.";
            }
            String urlString = String.format(base + this.template, values);
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"A valid URL could not be constructed from the provided parameters.");
            }
        }
        return url;
    }

    public URL buildWithQuery(String base, String queryString, Object ... values) {
        URL url;
        block4: {
            for (Object value : values) {
                String valueString = String.valueOf(value);
                if (!NUMERIC.matcher(valueString).matches()) assert (false) : "An invalid path param passed in. It must be numeric.";
            }
            String urlString = String.format(base + this.template, values) + queryString;
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"A valid URL could not be constructed from the provided parameters.");
            }
        }
        return url;
    }

    public URL buildAlphaWithQuery(String base, String queryString, Object ... values) {
        URL url;
        block4: {
            for (Object value : values) {
                String valueString = String.valueOf(value);
                if (!ALPHA_NUMERIC.matcher(valueString).matches()) assert (false) : "An invalid path param passed in. It must be alphanumeric.";
            }
            String urlString = String.format(base + this.template, values) + queryString;
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"A valid URL could not be constructed from the provided parameters.");
            }
        }
        return url;
    }
}

