/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxSignRequestSignerRole;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BoxSignRequestSigner
extends BoxJSONObject {
    private String email;
    private BoxSignRequestSignerRole role;
    private Boolean isInPerson;
    private Integer order;
    private String embedUrlExternalUserId;
    private Boolean hasViewedEmail;
    private Boolean hasViewedDocument;
    private BoxSignerDecision signerDecision;
    private List<BoxSignerInput> inputs;
    private String embedUrl;
    private BoxAPIConnection api;

    public BoxSignRequestSigner(String email) {
        this.email = email;
    }

    public BoxSignRequestSigner(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    public String getEmail() {
        return this.email;
    }

    public BoxSignRequestSignerRole getRole() {
        return this.role;
    }

    public boolean getIsInPerson() {
        return this.isInPerson;
    }

    public int getOrder() {
        return this.order;
    }

    public String getEmbedUrlExternalUserId() {
        return this.embedUrlExternalUserId;
    }

    public boolean getHasViewedEmail() {
        return this.hasViewedEmail;
    }

    public boolean getHasViewedDocument() {
        return this.hasViewedDocument;
    }

    public BoxSignerDecision getSignerDecision() {
        return this.signerDecision;
    }

    public List<BoxSignerInput> getInputs() {
        return this.inputs;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public BoxSignRequestSigner setEmail(String email) {
        this.email = email;
        return this;
    }

    public BoxSignRequestSigner setRole(BoxSignRequestSignerRole role) {
        this.role = role;
        return this;
    }

    public Boolean getInPerson() {
        return this.isInPerson;
    }

    public BoxSignRequestSigner setInPerson(Boolean isInPerson) {
        this.isInPerson = isInPerson;
        return this;
    }

    public BoxSignRequestSigner setOrder(Integer order) {
        this.order = order;
        return this;
    }

    public BoxSignRequestSigner setEmbedUrlExternalUserId(String embedUrlExternalUserId) {
        this.embedUrlExternalUserId = embedUrlExternalUserId;
        return this;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        try {
            if ("email".equals(memberName)) {
                this.email = value.asString();
            } else if ("role".equals(memberName)) {
                this.role = BoxSignRequestSignerRole.fromJSONString(value.asString());
            } else if ("is_in_person".equals(memberName)) {
                this.isInPerson = value.asBoolean();
            } else if ("order".equals(memberName)) {
                this.order = value.asInt();
            } else if ("embed_url_external_user_id".equals(memberName)) {
                this.embedUrlExternalUserId = value.asString();
            } else if ("has_viewed_email".equals(memberName)) {
                this.hasViewedEmail = value.asBoolean();
            } else if ("has_viewed_document".equals(memberName)) {
                this.hasViewedDocument = value.asBoolean();
            } else if ("signer_decision".equals(memberName)) {
                BoxSignerDecision signerDecision;
                JsonObject signerDecisionJSON = value.asObject();
                this.signerDecision = signerDecision = new BoxSignerDecision(signerDecisionJSON);
            } else if ("inputs".equals(memberName)) {
                ArrayList<BoxSignerInput> inputs = new ArrayList<BoxSignerInput>();
                for (JsonValue inputJSON : value.asArray()) {
                    BoxSignerInput input = new BoxSignerInput(inputJSON.asObject());
                    inputs.add(input);
                }
                this.inputs = inputs;
            } else if ("embed_url".equals(memberName)) {
                this.embedUrl = value.asString();
            }
        }
        catch (Exception e) {
            throw new BoxDeserializationException(memberName, value.toString(), e);
        }
    }

    public JsonObject getJSONObject() {
        JsonObject jsonObj = new JsonObject();
        JsonUtils.addIfNotNull(jsonObj, "email", this.email);
        JsonUtils.addIfNotNull(jsonObj, "role", this.role);
        JsonUtils.addIfNotNull(jsonObj, "is_in_person", this.isInPerson);
        JsonUtils.addIfNotNull(jsonObj, "order", this.order);
        JsonUtils.addIfNotNull(jsonObj, "embed_url_external_user_id", this.embedUrlExternalUserId);
        return jsonObj;
    }

    public static enum BoxSignRequestInputType {
        Signature("signature"),
        Text("text"),
        Checkbox("checkbox"),
        Date("date");

        private final String jsonValue;

        private BoxSignRequestInputType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestInputType fromJSONString(String jsonValue) {
            if ("signature".equals(jsonValue)) {
                return Signature;
            }
            if ("text".equals(jsonValue)) {
                return Text;
            }
            if ("checkbox".equals(jsonValue)) {
                return Checkbox;
            }
            if ("date".equals(jsonValue)) {
                return Date;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestInputType.");
        }
    }

    public static enum BoxSignRequestSignerDecisionType {
        Signed("signed"),
        Declined("declined");

        private final String jsonValue;

        private BoxSignRequestSignerDecisionType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestSignerDecisionType fromJSONString(String jsonValue) {
            if ("signed".equals(jsonValue)) {
                return Signed;
            }
            if ("declined".equals(jsonValue)) {
                return Declined;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestSignerDecisionType.");
        }
    }

    public class BoxSignerInput
    extends BoxJSONObject {
        private String documentTagId;
        private String textValue;
        private boolean checkboxValue;
        private Date dateValue;
        private BoxSignRequestInputType type;
        private int pageIndex;

        public BoxSignerInput(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getDocumentTagId() {
            return this.documentTagId;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public boolean getIsCheckboxValue() {
            return this.checkboxValue;
        }

        public Date getDateValue() {
            return this.dateValue;
        }

        public BoxSignRequestInputType getType() {
            return this.type;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                if ("documentTagId".equals(memberName)) {
                    this.documentTagId = value.asString();
                } else if ("text_value".equals(memberName)) {
                    this.textValue = value.asString();
                } else if ("checkbox_value".equals(memberName)) {
                    this.checkboxValue = value.asBoolean();
                } else if ("date_value".equals(memberName)) {
                    this.dateValue = BoxDateFormat.parse(value.asString());
                } else if ("type".equals(memberName)) {
                    this.type = BoxSignRequestInputType.fromJSONString(value.asString());
                } else if ("page_index".equals(memberName)) {
                    this.pageIndex = value.asInt();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public class BoxSignerDecision
    extends BoxJSONObject {
        private BoxSignRequestSignerDecisionType type;
        private Date finalizedAt;

        public BoxSignerDecision(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxSignRequestSignerDecisionType getType() {
            return this.type;
        }

        public Date getFinalizedAt() {
            return this.finalizedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                if (memberName.equals("type")) {
                    this.type = BoxSignRequestSignerDecisionType.fromJSONString(value.asString());
                } else if (memberName.equals("finalized_at")) {
                    this.finalizedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

