/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.DeveloperEditionEntityType;
import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.IAccessTokenCache;
import com.box.sdk.JWTEncryptionPreferences;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class BoxDeveloperEditionAPIConnection
extends BoxAPIConnection {
    private static final String JWT_AUDIENCE = "https://api.box.com/oauth2/token";
    private static final String JWT_GRANT_TYPE = "grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&client_id=%s&client_secret=%s&assertion=%s";
    private final String entityID;
    private final DeveloperEditionEntityType entityType;
    private final EncryptionAlgorithm encryptionAlgorithm;
    private final String publicKeyID;
    private final String privateKey;
    private final String privateKeyPassword;
    private IAccessTokenCache accessTokenCache;

    private BoxDeveloperEditionAPIConnection(String accessToken) {
        super(accessToken);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    private BoxDeveloperEditionAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        super(accessToken);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    private BoxDeveloperEditionAPIConnection(String clientID, String clientSecret, String authCode) {
        super(clientID, clientSecret, authCode);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    private BoxDeveloperEditionAPIConnection(String clientID, String clientSecret) {
        super(clientID, clientSecret);
        throw new BoxAPIException("This constructor is not available for BoxDeveloperEditionAPIConnection.");
    }

    @Deprecated
    public BoxDeveloperEditionAPIConnection(String entityId, DeveloperEditionEntityType entityType, String clientID, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        this(entityId, entityType, clientID, clientSecret, encryptionPref, null);
    }

    public BoxDeveloperEditionAPIConnection(String entityId, DeveloperEditionEntityType entityType, String clientID, String clientSecret, JWTEncryptionPreferences encryptionPref, IAccessTokenCache accessTokenCache) {
        super(clientID, clientSecret);
        this.entityID = entityId;
        this.entityType = entityType;
        this.publicKeyID = encryptionPref.getPublicKeyID();
        this.privateKey = encryptionPref.getPrivateKey();
        this.privateKeyPassword = encryptionPref.getPrivateKeyPassword();
        this.encryptionAlgorithm = encryptionPref.getEncryptionAlgorithm();
        this.accessTokenCache = accessTokenCache;
    }

    @Deprecated
    public static BoxDeveloperEditionAPIConnection getAppEnterpriseConnection(String enterpriseId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(enterpriseId, DeveloperEditionEntityType.ENTERPRISE, clientId, clientSecret, encryptionPref);
        connection.authenticate();
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppEnterpriseConnection(String enterpriseId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref, IAccessTokenCache accessTokenCache) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(enterpriseId, DeveloperEditionEntityType.ENTERPRISE, clientId, clientSecret, encryptionPref, accessTokenCache);
        connection.tryRestoreUsingAccessTokenCache();
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppEnterpriseConnection(BoxConfig boxConfig) {
        BoxDeveloperEditionAPIConnection connection = BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection(boxConfig.getEnterpriseId(), boxConfig.getClientId(), boxConfig.getClientSecret(), boxConfig.getJWTEncryptionPreferences());
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppEnterpriseConnection(BoxConfig boxConfig, IAccessTokenCache accessTokenCache) {
        BoxDeveloperEditionAPIConnection connection = BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection(boxConfig.getEnterpriseId(), boxConfig.getClientId(), boxConfig.getClientSecret(), boxConfig.getJWTEncryptionPreferences(), accessTokenCache);
        return connection;
    }

    @Deprecated
    public static BoxDeveloperEditionAPIConnection getAppUserConnection(String userId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(userId, DeveloperEditionEntityType.USER, clientId, clientSecret, encryptionPref);
        connection.authenticate();
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppUserConnection(String userId, String clientId, String clientSecret, JWTEncryptionPreferences encryptionPref, IAccessTokenCache accessTokenCache) {
        BoxDeveloperEditionAPIConnection connection = new BoxDeveloperEditionAPIConnection(userId, DeveloperEditionEntityType.USER, clientId, clientSecret, encryptionPref, accessTokenCache);
        connection.tryRestoreUsingAccessTokenCache();
        return connection;
    }

    public static BoxDeveloperEditionAPIConnection getAppUserConnection(String userId, BoxConfig boxConfig) {
        return BoxDeveloperEditionAPIConnection.getAppUserConnection(userId, boxConfig.getClientId(), boxConfig.getClientSecret(), boxConfig.getJWTEncryptionPreferences());
    }

    public static BoxDeveloperEditionAPIConnection getAppUserConnection(String userId, BoxConfig boxConfig, IAccessTokenCache accessTokenCache) {
        return BoxDeveloperEditionAPIConnection.getAppUserConnection(userId, boxConfig.getClientId(), boxConfig.getClientSecret(), boxConfig.getJWTEncryptionPreferences(), accessTokenCache);
    }

    @Override
    public void authenticate(String authCode) {
        throw new BoxAPIException("BoxDeveloperEditionAPIConnection does not allow authenticating with an auth code.");
    }

    public void authenticate() {
        URL url;
        try {
            url = new URL(this.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        String jwtAssertion = this.constructJWTAssertion();
        String urlParameters = String.format(JWT_GRANT_TYPE, this.getClientID(), this.getClientSecret(), jwtAssertion);
        BoxAPIRequest request = new BoxAPIRequest((BoxAPIConnection)this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        String json = response.getJSON();
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.setAccessToken(jsonObject.get("access_token").asString());
        this.setLastRefresh(System.currentTimeMillis());
        this.setExpires(jsonObject.get("expires_in").asLong() * 1000L);
        if (this.accessTokenCache != null) {
            String key = this.getAccessTokenCacheKey();
            JsonObject accessTokenCacheInfo = new JsonObject().add("accessToken", this.getAccessToken()).add("lastRefresh", this.getLastRefresh()).add("expires", this.getExpires());
            this.accessTokenCache.put(key, accessTokenCacheInfo.toString());
        }
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    @Override
    public void refresh() {
        this.getRefreshLock().writeLock().lock();
        try {
            this.authenticate();
        }
        catch (BoxAPIException e) {
            this.notifyError(e);
            this.getRefreshLock().writeLock().unlock();
            throw e;
        }
        this.notifyRefresh();
        this.getRefreshLock().writeLock().unlock();
    }

    private String getAccessTokenCacheKey() {
        return String.format("/%s/%s/%s/%s", this.getUserAgent(), this.getClientID(), this.entityType.toString(), this.entityID);
    }

    private void tryRestoreUsingAccessTokenCache() {
        if (this.accessTokenCache == null) {
            this.authenticate();
        } else {
            String cachedTokenInfo = this.accessTokenCache.get(this.getAccessTokenCacheKey());
            if (cachedTokenInfo == null) {
                this.authenticate();
            } else {
                JsonObject json = JsonObject.readFrom((String)cachedTokenInfo);
                this.setAccessToken(json.get("accessToken").asString());
                this.setLastRefresh(json.get("lastRefresh").asLong());
                this.setExpires(json.get("expires").asLong());
            }
        }
    }

    private String constructJWTAssertion() {
        String assertion;
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.getClientID());
        claims.setAudience(JWT_AUDIENCE);
        claims.setExpirationTimeMinutesInTheFuture(1.0f);
        claims.setSubject(this.entityID);
        claims.setClaim("box_sub_type", (Object)this.entityType.toString());
        claims.setGeneratedJwtId(64);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.decryptPrivateKey());
        jws.setAlgorithmHeaderValue(this.getAlgorithmIdentifier());
        jws.setHeader("typ", "JWT");
        if (this.publicKeyID != null && !this.publicKeyID.isEmpty()) {
            jws.setHeader("kid", this.publicKeyID);
        }
        try {
            assertion = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new BoxAPIException("Error serializing JSON Web Token assertion.", e);
        }
        return assertion;
    }

    private String getAlgorithmIdentifier() {
        String algorithmId = "RS256";
        switch (this.encryptionAlgorithm) {
            case RSA_SHA_384: {
                algorithmId = "RS384";
                break;
            }
            case RSA_SHA_512: {
                algorithmId = "RS512";
                break;
            }
        }
        return algorithmId;
    }

    private PrivateKey decryptPrivateKey() {
        PrivateKey decryptedPrivateKey = null;
        try {
            PEMParser keyReader = new PEMParser((Reader)new StringReader(this.privateKey));
            Object keyPair = keyReader.readObject();
            keyReader.close();
            if (keyPair instanceof PEMEncryptedKeyPair) {
                JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder();
                PEMDecryptorProvider decryptionProvider = builder.build(this.privateKeyPassword.toCharArray());
                keyPair = ((PEMEncryptedKeyPair)keyPair).decryptKeyPair(decryptionProvider);
                PrivateKeyInfo keyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
                decryptedPrivateKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
            } else if (keyPair instanceof PKCS8EncryptedPrivateKeyInfo) {
                InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC").build(this.privateKeyPassword.toCharArray());
                PrivateKeyInfo keyInfo = ((PKCS8EncryptedPrivateKeyInfo)keyPair).decryptPrivateKeyInfo(pkcs8Prov);
                decryptedPrivateKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
            } else {
                PrivateKeyInfo keyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
                decryptedPrivateKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Error parsing private key for Box Developer Edition.", e);
        }
        catch (OperatorCreationException e) {
            throw new BoxAPIException("Error parsing PKCS#8 private key for Box Developer Edition.", e);
        }
        catch (PKCSException e) {
            throw new BoxAPIException("Error parsing PKCS private key for Box Developer Edition.", e);
        }
        return decryptedPrivateKey;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

