/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;

public class Representation {
    private String representation;
    private Properties properties;
    private Metadata metadata;
    private String assetPath;
    private Info info;
    private Content content;
    private Status status;

    public Representation(JsonObject representationJson) {
        for (JsonObject.Member member : representationJson) {
            if (member.getName().equals("representation")) {
                this.representation = member.getValue().asString();
                continue;
            }
            if (member.getName().equals("properties")) {
                this.properties = new Properties(member.getValue().asObject());
                continue;
            }
            if (member.getName().equals("metadata")) {
                this.metadata = new Metadata(member.getValue().asObject());
                continue;
            }
            if (member.getName().equals("assetPath")) {
                this.assetPath = member.getValue().asString();
                continue;
            }
            if (member.getName().equals("info")) {
                this.info = new Info(member.getValue().asObject());
                continue;
            }
            if (member.getName().equals("content")) {
                this.content = new Content(member.getValue().asObject());
                continue;
            }
            if (!member.getName().equals("status")) continue;
            this.status = new Status(member.getValue().asObject());
        }
    }

    public String getRepresentation() {
        return this.representation;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public Info getInfo() {
        return this.info;
    }

    public Content getContent() {
        return this.content;
    }

    public Status getStatus() {
        return this.status;
    }

    public class Status {
        private String state;

        public Status(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("state")) continue;
                this.state = member.getValue().asString();
            }
        }

        public String getState() {
            return this.state;
        }
    }

    public class Content {
        private String urlTemplate;

        public Content(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("url_template")) continue;
                this.urlTemplate = member.getValue().asString();
            }
        }

        public String getUrlTemplate() {
            return this.urlTemplate;
        }
    }

    public class Info {
        private URL url;

        public Info(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("url")) continue;
                try {
                    this.url = new URL(member.getValue().asString());
                }
                catch (MalformedURLException e) {
                    throw new BoxAPIException("Couldn't parse info.url for a file representation", e);
                }
            }
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public class Metadata {
        private int pages;
        private JsonObject jsonObject;

        public Metadata(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (!member.getName().equals("pages")) continue;
                this.pages = member.getValue().asInt();
            }
            this.jsonObject = members;
        }

        public int getPages() {
            return this.pages;
        }

        public JsonValue get(String field) {
            return this.jsonObject.get(field);
        }
    }

    public class Properties {
        private String dimensions;
        private String paged;
        private String thumb;

        public Properties(JsonObject members) {
            for (JsonObject.Member member : members) {
                if (member.getName().equals("dimensions")) {
                    this.dimensions = member.getValue().asString();
                    continue;
                }
                if (member.getName().equals("paged")) {
                    this.paged = member.getValue().asString();
                    continue;
                }
                if (!member.getName().equals("thumb")) continue;
                this.thumb = member.getValue().asString();
            }
        }

        public String getDimensions() {
            return this.dimensions;
        }

        public String getPaged() {
            return this.paged;
        }

        public String getThumb() {
            return this.thumb;
        }
    }
}

