/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.JsonObject;
import java.net.URL;

public class BoxJSONRequest
extends BoxAPIRequest {
    private JsonObject jsonObject;

    public BoxJSONRequest(BoxAPIConnection api, URL url, String method) {
        super(api, url, method);
        this.addHeader("Content-Type", "application/json");
    }

    public BoxJSONRequest(BoxAPIConnection api, URL url, HttpMethod method) {
        super(api, url, method);
        this.addHeader("Content-Type", "application/json");
    }

    public BoxJSONRequest(URL url, HttpMethod method) {
        super(url, method);
        this.addHeader("Content-Type", "application/json");
    }

    @Override
    public void setBody(String body) {
        super.setBody(body);
        this.jsonObject = JsonObject.readFrom((String)body);
    }

    public void setBody(JsonObject body) {
        super.setBody(body.toString());
        this.jsonObject = body;
    }

    public JsonObject getBodyAsJsonObject() {
        return this.jsonObject;
    }

    @Override
    protected String bodyToString() {
        return this.jsonObject.toString();
    }
}

