/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="collaboration_allowlist_entry")
public class BoxCollaborationAllowlist
extends BoxResource {
    public static final URLTemplate COLLABORATION_ALLOWLIST_ENTRIES_URL_TEMPLATE = new URLTemplate("collaboration_whitelist_entries");
    public static final URLTemplate COLLABORATION_ALLOWLIST_ENTRY_URL_TEMPLATE = new URLTemplate("collaboration_whitelist_entries/%s");
    private static final int DEFAULT_LIMIT = 100;

    public BoxCollaborationAllowlist(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxAPIConnection api, String domain, AllowlistDirection direction) {
        BoxCollaborationAllowlist domainAllowlist;
        URL url = COLLABORATION_ALLOWLIST_ENTRIES_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, HttpMethod.POST);
        JsonObject requestJSON = new JsonObject().add("domain", domain).add("direction", direction.toString());
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxCollaborationAllowlist boxCollaborationAllowlist = domainAllowlist = new BoxCollaborationAllowlist(api, responseJSON.get("id").asString());
        boxCollaborationAllowlist.getClass();
        return boxCollaborationAllowlist.new Info(responseJSON);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxCollaborationAllowlist.getAll(api, 100, fields);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = COLLABORATION_ALLOWLIST_ENTRIES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxCollaborationAllowlist allowlist;
                BoxCollaborationAllowlist boxCollaborationAllowlist = allowlist = new BoxCollaborationAllowlist(api, jsonObject.get("id").asString());
                boxCollaborationAllowlist.getClass();
                return boxCollaborationAllowlist.new Info(jsonObject);
            }
        };
    }

    public Info getInfo() {
        URL url = COLLABORATION_ALLOWLIST_ENTRY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, HttpMethod.GET);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(JsonObject.readFrom((String)response.getJSON()));
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_ALLOWLIST_ENTRY_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, HttpMethod.DELETE);
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private String type;
        private String domain;
        private AllowlistDirection direction;
        private BoxEnterprise enterprise;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getType() {
            return this.type;
        }

        public String getDomain() {
            return this.domain;
        }

        public AllowlistDirection getDirection() {
            return this.direction;
        }

        public BoxEnterprise getEnterprise() {
            return this.enterprise;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        public BoxCollaborationAllowlist getResource() {
            return BoxCollaborationAllowlist.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("domain")) {
                    this.domain = value.asString();
                } else if (memberName.equals("type")) {
                    this.type = value.asString();
                } else if (memberName.equals("direction")) {
                    this.direction = AllowlistDirection.fromDirection(value.asString());
                } else if (memberName.equals("enterprise")) {
                    JsonObject jsonObject = value.asObject();
                    this.enterprise = new BoxEnterprise(jsonObject);
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static enum AllowlistDirection {
        INBOUND("inbound"),
        OUTBOUND("outbound"),
        BOTH("both");

        private final String direction;

        private AllowlistDirection(String direction) {
            this.direction = direction;
        }

        static AllowlistDirection fromDirection(String direction) {
            if (direction.equals("inbound")) {
                return INBOUND;
            }
            if (direction.equals("outbound")) {
                return OUTBOUND;
            }
            if (direction.equals("both")) {
                return BOTH;
            }
            return null;
        }

        public String toString() {
            return this.direction;
        }
    }
}

