/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@BoxResourceType(value="group_membership")
public class BoxGroupMembership
extends BoxResource {
    public static final URLTemplate MEMBERSHIP_URL_TEMPLATE = new URLTemplate("group_memberships/%s");

    public BoxGroupMembership(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject);
    }

    public void updateInfo(Info info) {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info user;
        private BoxGroup.Info group;
        private Role role;
        private GroupRole groupRole;
        private Date createdAt;
        private Date modifiedAt;
        private Map<Permission, Boolean> configurablePermissions;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxUser.Info getUser() {
            return this.user;
        }

        public BoxGroup.Info getGroup() {
            return this.group;
        }

        @Deprecated
        public Role getRole() {
            return this.role;
        }

        @Deprecated
        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public GroupRole getGroupRole() {
            return this.groupRole;
        }

        public void setGroupRole(GroupRole role) {
            this.groupRole = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public Map<Permission, Boolean> getConfigurablePermissions() {
            return this.configurablePermissions;
        }

        public void setConfigurablePermissions(Map<Permission, Boolean> configurablePermissions) {
            this.configurablePermissions = configurablePermissions;
            this.addPendingChange("configurable_permissions", this.configurablePermissionJson());
        }

        public void appendConfigurablePermissions(Permission permission, Boolean value) {
            this.configurablePermissions.put(permission, value);
            this.addPendingChange("configurable_permissions", this.configurablePermissionJson());
        }

        private JsonObject configurablePermissionJson() {
            JsonObject configurablePermissionJson = new JsonObject();
            for (Permission attrKey : this.configurablePermissions.keySet()) {
                configurablePermissionJson.set(attrKey.toJSONValue(), this.configurablePermissions.get((Object)attrKey).booleanValue());
            }
            return configurablePermissionJson;
        }

        @Override
        public BoxGroupMembership getResource() {
            return BoxGroupMembership.this;
        }

        private Map<Permission, Boolean> parseConfigurablePermissions(JsonObject jsonObject) {
            if (jsonObject == null) {
                return null;
            }
            HashMap<Permission, Boolean> permissions = new HashMap<Permission, Boolean>();
            for (JsonObject.Member member : jsonObject) {
                String memberName = member.getName();
                boolean memberValue = member.getValue().asBoolean();
                if (memberName.equals("can_create_accounts")) {
                    permissions.put(Permission.CAN_CREATE_ACCOUNTS, memberValue);
                    continue;
                }
                if (memberName.equals("can_edit_accounts")) {
                    permissions.put(Permission.CAN_EDIT_ACCOUNTS, memberValue);
                    continue;
                }
                if (memberName.equals("can_instant_login")) {
                    permissions.put(Permission.CAN_INSTANT_LOGIN, memberValue);
                    continue;
                }
                if (!memberName.equals("can_run_reports")) continue;
                permissions.put(Permission.CAN_RUN_REPORTS, memberValue);
            }
            return permissions;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("user")) {
                    JsonObject userJSON = value.asObject();
                    if (this.user == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxGroupMembership.this.getAPI(), userID);
                        boxUser.getClass();
                        this.user = boxUser.new BoxUser.Info(userJSON);
                    } else {
                        this.user.update(userJSON);
                    }
                } else if (memberName.equals("group")) {
                    JsonObject groupJSON = value.asObject();
                    if (this.group == null) {
                        BoxGroup group;
                        String userID = groupJSON.get("id").asString();
                        BoxGroup boxGroup = group = new BoxGroup(BoxGroupMembership.this.getAPI(), userID);
                        boxGroup.getClass();
                        this.group = boxGroup.new BoxGroup.Info(groupJSON);
                    } else {
                        this.group.update(groupJSON);
                    }
                } else if (memberName.equals("role")) {
                    this.role = Role.fromJSONString(value.asString());
                    this.groupRole = GroupRole.fromJSONString(value.asString());
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("configurable_permissions")) {
                    this.configurablePermissions = this.parseConfigurablePermissions(value.asObject());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static enum Permission {
        CAN_CREATE_ACCOUNTS("can_create_accounts"),
        CAN_EDIT_ACCOUNTS("can_edit_accounts"),
        CAN_INSTANT_LOGIN("can_instant_login"),
        CAN_RUN_REPORTS("can_run_reports");

        private final String jsonValue;

        private Permission(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Permission fromJSONValue(String jsonValue) {
            return Permission.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum GroupRole {
        ADMIN("admin"),
        COADMIN("submaster"),
        MEMBER("member");

        private final String jsonValue;

        private GroupRole(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static GroupRole fromJSONString(String jsonValue) {
            for (GroupRole role : GroupRole.values()) {
                if (!role.jsonValue.equalsIgnoreCase(jsonValue)) continue;
                return role;
            }
            throw new IllegalArgumentException("Invalid value for enum GroupRole: " + jsonValue);
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    @Deprecated
    public static enum Role {
        ADMIN("admin"),
        SUBMASTER("submaster"),
        MEMBER("member");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONString(String jsonValue) {
            return Role.valueOf(jsonValue.toUpperCase());
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }
}

