/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicyAssignment;
import com.box.sdk.BoxUser;
import com.box.sdk.MetadataFieldFilter;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.RetentionPolicyParams;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="retention_policy")
public class BoxRetentionPolicy
extends BoxResource {
    public static final URLTemplate RETENTION_POLICIES_URL_TEMPLATE = new URLTemplate("retention_policies");
    public static final URLTemplate POLICY_URL_TEMPLATE = new URLTemplate("retention_policies/%s");
    public static final URLTemplate ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("retention_policies/%s/assignments");
    public static final String ACTION_PERMANENTLY_DELETE = "permanently_delete";
    public static final String ACTION_REMOVE_RETENTION = "remove_retention";
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_RETIRED = "retired";
    private static final int DEFAULT_LIMIT = 100;

    public BoxRetentionPolicy(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createIndefinitePolicy(BoxAPIConnection api, String name) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Indefinite, 0, BoxRetentionPolicyAction.RemoveRetention);
    }

    public static Info createIndefinitePolicy(BoxAPIConnection api, String name, RetentionPolicyParams optionalParams) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Indefinite, 0, BoxRetentionPolicyAction.RemoveRetention, optionalParams);
    }

    @Deprecated
    public static Info createFinitePolicy(BoxAPIConnection api, String name, int length, String action) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Finite, length, BoxRetentionPolicyAction.valueOf(action));
    }

    public static Info createFinitePolicy(BoxAPIConnection api, String name, int length, BoxRetentionPolicyAction action) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Finite, length, action);
    }

    @Deprecated
    public static Info createFinitePolicy(BoxAPIConnection api, String name, int length, String action, RetentionPolicyParams optionalParams) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Finite, length, BoxRetentionPolicyAction.valueOf(action), optionalParams);
    }

    public static Info createFinitePolicy(BoxAPIConnection api, String name, int length, BoxRetentionPolicyAction action, RetentionPolicyParams optionalParams) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, BoxRetentionPolicyType.Finite, length, action, optionalParams);
    }

    private static Info createRetentionPolicy(BoxAPIConnection api, String name, BoxRetentionPolicyType type, int length, BoxRetentionPolicyAction action) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, type, length, action, null);
    }

    private static Info createRetentionPolicy(BoxAPIConnection api, String name, BoxRetentionPolicyType type, int length, BoxRetentionPolicyAction action, RetentionPolicyParams optionalParams) {
        BoxRetentionPolicy createdPolicy;
        URL url = RETENTION_POLICIES_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_name", name).add("policy_type", type.value).add("disposition_action", action.value);
        if (type != BoxRetentionPolicyType.Indefinite) {
            requestJSON.add("retention_length", length);
        }
        if (optionalParams != null) {
            requestJSON.add("can_owner_extend_retention", optionalParams.getCanOwnerExtendRetention());
            requestJSON.add("are_owners_notified", optionalParams.getAreOwnersNotified());
            requestJSON.add("description", optionalParams.getDescription());
            List<BoxUser.Info> customNotificationRecipients = optionalParams.getCustomNotificationRecipients();
            if (customNotificationRecipients.size() > 0) {
                JsonArray users = new JsonArray();
                for (BoxUser.Info user : customNotificationRecipients) {
                    JsonObject userJSON = new JsonObject().add("type", "user").add("id", user.getID());
                    users.add((JsonValue)userJSON);
                }
                requestJSON.add("custom_notification_recipients", (JsonValue)users);
            }
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        BoxRetentionPolicy boxRetentionPolicy = createdPolicy = new BoxRetentionPolicy(api, responseJSON.get("id").asString());
        boxRetentionPolicy.getClass();
        return boxRetentionPolicy.new Info(responseJSON);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxRetentionPolicy.getAll(null, null, null, 100, api, fields);
    }

    public static Iterable<Info> getAll(String name, String type, String userID, int limit, final BoxAPIConnection api, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (name != null) {
            queryString.appendParam("policy_name", name);
        }
        if (type != null) {
            queryString.appendParam("policy_type", type);
        }
        if (userID != null) {
            queryString.appendParam("created_by_user_id", userID);
        }
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = RETENTION_POLICIES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxRetentionPolicy policy;
                BoxRetentionPolicy boxRetentionPolicy = policy = new BoxRetentionPolicy(api, jsonObject.get("id").asString());
                boxRetentionPolicy.getClass();
                return boxRetentionPolicy.new Info(jsonObject);
            }
        };
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getFolderAssignments(String ... fields) {
        return this.getFolderAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getFolderAssignments(int limit, String ... fields) {
        return this.getAssignments("folder", limit, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getEnterpriseAssignments(String ... fields) {
        return this.getEnterpriseAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getEnterpriseAssignments(int limit, String ... fields) {
        return this.getAssignments("enterprise", limit, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getAllAssignments(String ... fields) {
        return this.getAllAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getAllAssignments(int limit, String ... fields) {
        return this.getAssignments(null, limit, fields);
    }

    private Iterable<BoxRetentionPolicyAssignment.Info> getAssignments(String type, int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (type != null) {
            queryString.appendParam("type", type);
        }
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = ASSIGNMENTS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString.toString(), this.getID());
        return new BoxResourceIterable<BoxRetentionPolicyAssignment.Info>(this.getAPI(), url, limit){

            @Override
            protected BoxRetentionPolicyAssignment.Info factory(JsonObject jsonObject) {
                BoxRetentionPolicyAssignment assignment;
                BoxRetentionPolicyAssignment boxRetentionPolicyAssignment = assignment = new BoxRetentionPolicyAssignment(BoxRetentionPolicy.this.getAPI(), jsonObject.get("id").asString());
                boxRetentionPolicyAssignment.getClass();
                return new BoxRetentionPolicyAssignment.Info(boxRetentionPolicyAssignment, jsonObject);
            }
        };
    }

    public BoxRetentionPolicyAssignment.Info assignTo(BoxFolder folder) {
        return BoxRetentionPolicyAssignment.createAssignmentToFolder(this.getAPI(), this.getID(), folder.getID());
    }

    public BoxRetentionPolicyAssignment.Info assignToEnterprise() {
        return BoxRetentionPolicyAssignment.createAssignmentToEnterprise(this.getAPI(), this.getID());
    }

    public BoxRetentionPolicyAssignment.Info assignToMetadataTemplate(String templateID, MetadataFieldFilter ... fieldFilters) {
        return this.assignToMetadataTemplate(templateID, (String)null, fieldFilters);
    }

    public BoxRetentionPolicyAssignment.Info assignToMetadataTemplate(String templateID, String startDateField, MetadataFieldFilter ... fieldFilters) {
        return BoxRetentionPolicyAssignment.createAssignmentToMetadata(this.getAPI(), this.getID(), templateID, startDateField, fieldFilters);
    }

    public void updateInfo(Info info) {
        URL url = POLICY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        info.update(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = POLICY_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new Info(responseJSON);
    }

    public static enum BoxRetentionPolicyAction {
        PermanentlyDelete("permanently_delete"),
        RemoveRetention("remove_retention");

        private final String value;

        private BoxRetentionPolicyAction(String value) {
            this.value = value;
        }
    }

    private static enum BoxRetentionPolicyType {
        Finite("finite"),
        Indefinite("indefinite");

        private final String value;

        private BoxRetentionPolicyType(String value) {
            this.value = value;
        }
    }

    public class Info
    extends BoxResource.Info {
        private String policyName;
        private String policyType;
        private int retentionLength;
        private String dispositionAction;
        private String status;
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;
        private boolean canOwnerExtendRetention;
        private boolean areOwnersNotified;
        private String description;
        private List<BoxUser.Info> customNotificationRecipients;

        public Info() {
            super(BoxRetentionPolicy.this);
        }

        public Info(String json) {
            super((BoxResource)BoxRetentionPolicy.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxRetentionPolicy.this, jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxRetentionPolicy.this;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
            this.addPendingChange("policy_name", policyName);
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public int getRetentionLength() {
            return this.retentionLength;
        }

        public String getDispositionAction() {
            return this.dispositionAction;
        }

        public void setDispositionAction(String dispositionAction) {
            this.dispositionAction = dispositionAction;
            this.addPendingChange("disposition_action", dispositionAction);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
            this.addPendingChange("status", status);
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public boolean getCanOwnerExtendRetention() {
            return this.canOwnerExtendRetention;
        }

        public boolean getAreOwnersNotified() {
            return this.areOwnersNotified;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public List<BoxUser.Info> getCustomNotificationRecipients() {
            return this.customNotificationRecipients;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("policy_name")) {
                    this.policyName = value.asString();
                } else if (memberName.equals("policy_type")) {
                    this.policyType = value.asString();
                } else if (memberName.equals("retention_length")) {
                    int intVal = value.asString().equals(BoxRetentionPolicyType.Indefinite.value) ? -1 : Integer.parseInt(value.asString());
                    this.retentionLength = intVal;
                } else if (memberName.equals("disposition_action")) {
                    this.dispositionAction = value.asString();
                } else if (memberName.equals("status")) {
                    this.status = value.asString();
                } else if (memberName.equals("created_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxRetentionPolicy.this.getAPI(), userID);
                        boxUser.getClass();
                        this.createdBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("can_owner_extend_retention")) {
                    this.canOwnerExtendRetention = value.asBoolean();
                } else if (memberName.equals("are_owners_notified")) {
                    this.areOwnersNotified = value.asBoolean();
                } else if (memberName.equals("description")) {
                    this.description = value.asString();
                } else if (memberName.equals("custom_notification_recipients")) {
                    ArrayList<BoxUser.Info> recipients = new ArrayList<BoxUser.Info>();
                    for (JsonValue userJSON : value.asArray()) {
                        BoxUser user;
                        String userID = userJSON.asObject().get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxRetentionPolicy.this.getAPI(), userID);
                        boxUser.getClass();
                        recipients.add(new BoxUser.Info(boxUser, userJSON.asObject()));
                    }
                    this.customNotificationRecipients = recipients;
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

