/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;

public class BoxJSONRequest
extends BoxAPIRequest {
    private JsonValue jsonValue;

    public BoxJSONRequest(BoxAPIConnection api, URL url, String method) {
        super(api, url, method);
        this.addHeader("Content-Type", "application/json");
    }

    public BoxJSONRequest(BoxAPIConnection api, URL url, HttpMethod method) {
        super(api, url, method);
        this.addHeader("Content-Type", "application/json");
    }

    public BoxJSONRequest(URL url, HttpMethod method) {
        super(url, method);
        this.addHeader("Content-Type", "application/json");
    }

    @Override
    public void setBody(String body) {
        super.setBody(body);
        this.jsonValue = Json.parse((String)body);
    }

    public void setBody(JsonObject body) {
        super.setBody(body.toString());
        this.jsonValue = body;
    }

    public JsonObject getBodyAsJsonObject() {
        if (this.jsonValue.isObject()) {
            return this.jsonValue.asObject();
        }
        return null;
    }

    public JsonValue getBodyAsJsonValue() {
        return this.jsonValue;
    }

    @Override
    protected String bodyToString() {
        return this.jsonValue.toString();
    }
}

