/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.util.logging.Level;
import java.util.logging.Logger;

final class BoxLogger {
    private final Logger logger;

    private BoxLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public static BoxLogger defaultLogger() {
        return new BoxLogger("com.box.sdk");
    }

    void debug(String message) {
        this.logger.fine(message);
    }

    void warn(String message) {
        this.logger.warning(message);
    }

    void error(String message) {
        this.logger.severe(message);
    }

    boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }
}

