/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicy;
import com.box.sdk.BoxUser;
import com.box.sdk.MetadataFieldFilter;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="retention_policy_assignment")
public class BoxRetentionPolicyAssignment
extends BoxResource {
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_ENTERPRISE = "enterprise";
    public static final String TYPE_METADATA = "metadata_template";
    public static final URLTemplate ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("retention_policy_assignments");
    public static final URLTemplate RETENTION_POLICY_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("retention_policy_assignments/%s");
    public static final URLTemplate FILES_UNDER_RETENTION_URL_TEMPLATE = new URLTemplate("retention_policy_assignments/%s/files_under_retention");
    public static final URLTemplate FILE_VERSIONS_UNDER_RETENTION_URL_TEMPLATE = new URLTemplate("retention_policy_assignments/%s/file_versions_under_retention");
    private static final int DEFAULT_LIMIT = 100;

    public BoxRetentionPolicyAssignment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createAssignmentToEnterprise(BoxAPIConnection api, String policyID) {
        return BoxRetentionPolicyAssignment.createAssignment(api, policyID, new JsonObject().add("type", TYPE_ENTERPRISE), null, null);
    }

    public static Info createAssignmentToFolder(BoxAPIConnection api, String policyID, String folderID) {
        return BoxRetentionPolicyAssignment.createAssignment(api, policyID, new JsonObject().add("type", TYPE_FOLDER).add("id", folderID), null, null);
    }

    public static Info createAssignmentToMetadata(BoxAPIConnection api, String policyID, String templateID, MetadataFieldFilter ... filter) {
        return BoxRetentionPolicyAssignment.createAssignmentToMetadata(api, policyID, templateID, null, filter);
    }

    public static Info createAssignmentToMetadata(BoxAPIConnection api, String policyID, String templateID, String startDateField, MetadataFieldFilter ... filter) {
        JsonObject assignTo = new JsonObject().add("type", TYPE_METADATA).add("id", templateID);
        JsonArray filters = null;
        if (filter.length > 0) {
            filters = new JsonArray();
            for (MetadataFieldFilter f : filter) {
                filters.add((JsonValue)f.getJsonObject());
            }
        }
        return BoxRetentionPolicyAssignment.createAssignment(api, policyID, assignTo, startDateField, filters);
    }

    private static Info createAssignment(BoxAPIConnection api, String policyID, JsonObject assignTo, String startDateField, JsonArray filter) {
        BoxRetentionPolicyAssignment createdAssignment;
        URL url = ASSIGNMENTS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_id", policyID).add("assign_to", (JsonValue)assignTo);
        if (filter != null) {
            requestJSON.add("filter_fields", (JsonValue)filter);
        }
        if (startDateField != null) {
            requestJSON.add("start_date_field", startDateField);
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        BoxRetentionPolicyAssignment boxRetentionPolicyAssignment = createdAssignment = new BoxRetentionPolicyAssignment(api, responseJSON.get("id").asString());
        boxRetentionPolicyAssignment.getClass();
        return boxRetentionPolicyAssignment.new Info(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = RETENTION_POLICY_ASSIGNMENT_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new Info(responseJSON);
    }

    public Iterable<BoxFile.Info> getFilesUnderRetention(String ... fields) {
        return this.getFilesUnderRetention(100, fields);
    }

    public Iterable<BoxFile.Info> getFilesUnderRetention(int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = FILES_UNDER_RETENTION_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString.toString(), this.getID());
        return new BoxResourceIterable<BoxFile.Info>(this.getAPI(), url, limit){

            @Override
            protected BoxFile.Info factory(JsonObject jsonObject) {
                BoxFile boxFile;
                BoxFile boxFile2 = boxFile = new BoxFile(BoxRetentionPolicyAssignment.this.getAPI(), jsonObject.get("id").asString());
                boxFile2.getClass();
                return boxFile2.new BoxFile.Info(jsonObject);
            }
        };
    }

    public Iterable<BoxFile.Info> getFileVersionsUnderRetention(String ... fields) {
        return this.getFileVersionsUnderRetention(100, fields);
    }

    public Iterable<BoxFile.Info> getFileVersionsUnderRetention(int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = FILE_VERSIONS_UNDER_RETENTION_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString.toString(), this.getID());
        return new BoxResourceIterable<BoxFile.Info>(this.getAPI(), url, limit){

            @Override
            protected BoxFile.Info factory(JsonObject jsonObject) {
                BoxFile boxFile;
                BoxFile boxFile2 = boxFile = new BoxFile(BoxRetentionPolicyAssignment.this.getAPI(), jsonObject.get("id").asString());
                boxFile2.getClass();
                return boxFile2.new BoxFile.Info(jsonObject);
            }
        };
    }

    public class Info
    extends BoxResource.Info {
        private BoxRetentionPolicy.Info retentionPolicy;
        private BoxUser.Info assignedBy;
        private Date assignedAt;
        private String assignedToType;
        private String assignedToID;
        private String startDateField;
        private List<MetadataFieldFilter> filterFields;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxRetentionPolicyAssignment.this;
        }

        public BoxRetentionPolicy.Info getRetentionPolicy() {
            return this.retentionPolicy;
        }

        public BoxUser.Info getAssignedBy() {
            return this.assignedBy;
        }

        public Date getAssignedAt() {
            return this.assignedAt;
        }

        public String getAssignedToType() {
            return this.assignedToType;
        }

        public String getAssignedToID() {
            return this.assignedToID;
        }

        public String getStartDateField() {
            return this.startDateField;
        }

        public List<MetadataFieldFilter> getFilterFields() {
            return this.filterFields;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("retention_policy")) {
                    JsonObject policyJSON = value.asObject();
                    if (this.retentionPolicy == null) {
                        BoxRetentionPolicy policy;
                        String policyID = policyJSON.get("id").asString();
                        BoxRetentionPolicy boxRetentionPolicy = policy = new BoxRetentionPolicy(BoxRetentionPolicyAssignment.this.getAPI(), policyID);
                        boxRetentionPolicy.getClass();
                        this.retentionPolicy = boxRetentionPolicy.new BoxRetentionPolicy.Info(policyJSON);
                    } else {
                        this.retentionPolicy.update(policyJSON);
                    }
                } else if (memberName.equals("assigned_to")) {
                    JsonObject assignmentJSON = value.asObject();
                    this.assignedToType = assignmentJSON.get("type").asString();
                    this.assignedToID = this.assignedToType.equals(BoxRetentionPolicyAssignment.TYPE_ENTERPRISE) ? null : assignmentJSON.get("id").asString();
                } else if (memberName.equals("assigned_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.assignedBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxRetentionPolicyAssignment.this.getAPI(), userID);
                        boxUser.getClass();
                        this.assignedBy = boxUser.new BoxUser.Info(userJSON);
                    } else {
                        this.assignedBy.update(userJSON);
                    }
                } else if (memberName.equals("assigned_at")) {
                    this.assignedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("start_date_field")) {
                    this.startDateField = value.asString();
                } else if (memberName.equals("filter_fields")) {
                    JsonArray jsonFilters = value.asArray();
                    ArrayList<MetadataFieldFilter> filterFields = new ArrayList<MetadataFieldFilter>();
                    for (int i = 0; i < jsonFilters.size(); ++i) {
                        filterFields.add(new MetadataFieldFilter(jsonFilters.get(i).asObject()));
                    }
                    this.filterFields = filterFields;
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

