/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxConfig;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.net.URL;

public final class BoxCCGAPIConnection
extends BoxAPIConnection {
    static final String ENTERPRISE_SUBJECT_TYPE = "enterprise";
    static final String USER_SUBJECT_TYPE = "user";
    private String subjectType;
    private String subjectId;

    private BoxCCGAPIConnection(String accessToken) {
        super(accessToken);
    }

    private BoxCCGAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        super(clientID, clientSecret, accessToken, refreshToken);
    }

    private BoxCCGAPIConnection(String clientID, String clientSecret, String authCode) {
        super(clientID, clientSecret, authCode);
    }

    private BoxCCGAPIConnection(String clientID, String clientSecret) {
        super(clientID, clientSecret);
    }

    private BoxCCGAPIConnection(BoxConfig boxConfig) {
        super(boxConfig);
    }

    public static BoxCCGAPIConnection applicationServiceAccountConnection(String clientId, String clientSecret, String enterpriseId) {
        BoxCCGAPIConnection api = new BoxCCGAPIConnection(clientId, clientSecret);
        api.subjectType = ENTERPRISE_SUBJECT_TYPE;
        api.subjectId = enterpriseId;
        return api;
    }

    public static BoxCCGAPIConnection userConnection(String clientId, String clientSecret, String userId) {
        BoxCCGAPIConnection api = new BoxCCGAPIConnection(clientId, clientSecret);
        api.subjectType = USER_SUBJECT_TYPE;
        api.subjectId = userId;
        return api;
    }

    public static BoxCCGAPIConnection restore(String clientID, String clientSecret, String state) {
        BoxCCGAPIConnection api = new BoxCCGAPIConnection(clientID, clientSecret);
        api.restore(state);
        return api;
    }

    @Override
    protected BoxAPIRequest createTokenRequest(URL url) {
        String urlParameters = String.format("grant_type=client_credentials&client_id=%s&client_secret=%s&box_subject_type=%s&box_subject_id=%s", this.getClientID(), this.getClientSecret(), this.subjectType, this.subjectId);
        BoxAPIRequest request = new BoxAPIRequest((BoxAPIConnection)this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        return request;
    }

    @Override
    protected void extractTokens(JsonObject jsonObject) {
        this.setAccessToken(jsonObject.get("access_token").asString());
        this.setLastRefresh(System.currentTimeMillis());
        this.setExpires(jsonObject.get("expires_in").asLong() * 1000L);
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public boolean isUserConnection() {
        return this.subjectType.equals(USER_SUBJECT_TYPE);
    }

    @Override
    public String save() {
        JsonObject state = new JsonObject().add("accessToken", this.getAccessToken()).add("lastRefresh", this.getLastRefresh()).add("expires", this.getExpires()).add("userAgent", this.getUserAgent()).add("tokenURL", this.getTokenURL()).add("baseURL", this.getBaseURL()).add("baseUploadURL", this.getBaseUploadURL()).add("autoRefresh", this.getAutoRefresh()).add("maxRetryAttempts", this.getMaxRetryAttempts()).add("subjectType", this.subjectType).add("subjectId", this.subjectId);
        return state.toString();
    }

    @Override
    public void restore(String state) {
        JsonObject json = Json.parse((String)state).asObject();
        String accessToken = json.get("accessToken").asString();
        long lastRefresh = json.get("lastRefresh").asLong();
        long expires = json.get("expires").asLong();
        String userAgent = json.get("userAgent").asString();
        String tokenURL = json.get("tokenURL").asString();
        String baseURL = json.get("baseURL").asString();
        String baseUploadURL = json.get("baseUploadURL").asString();
        boolean autoRefresh = json.get("autoRefresh").asBoolean();
        String subjectType = json.get("subjectType").asString();
        String subjectId = json.get("subjectId").asString();
        int maxRetryAttempts = -1;
        if (json.names().contains("maxRetryAttempts")) {
            maxRetryAttempts = json.get("maxRetryAttempts").asInt();
        }
        this.setAccessToken(accessToken);
        this.setLastRefresh(lastRefresh);
        this.setExpires(expires);
        this.setUserAgent(userAgent);
        this.setTokenURL(tokenURL);
        this.setBaseURL(baseURL);
        this.setBaseUploadURL(baseUploadURL);
        this.setAutoRefresh(autoRefresh);
        this.setMaxRetryAttempts(maxRetryAttempts);
        this.subjectType = subjectType;
        this.subjectId = subjectId;
    }
}

