/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;

public class BoxSignRequestPrefillTag
extends BoxJSONObject {
    private String documentTagId;
    private String textValue;
    private Boolean checkboxValue;
    private Date dateValue;

    public BoxSignRequestPrefillTag(String documentTagId, String textValue) {
        this.documentTagId = documentTagId;
        this.textValue = textValue;
    }

    public BoxSignRequestPrefillTag(String documentTagId, Boolean checkboxValue) {
        this.documentTagId = documentTagId;
        this.checkboxValue = checkboxValue;
    }

    public BoxSignRequestPrefillTag(String documentTagId, Date dateValue) {
        this.documentTagId = documentTagId;
        this.dateValue = dateValue;
    }

    public BoxSignRequestPrefillTag(String json) {
        super(json);
    }

    BoxSignRequestPrefillTag(JsonObject jsonObject) {
        super(jsonObject);
    }

    public String getDocumentTagId() {
        return this.documentTagId;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public Boolean getCheckboxValue() {
        return this.checkboxValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public JsonObject getJSONObject() {
        JsonObject prefillTagObj = new JsonObject();
        JsonUtils.addIfNotNull(prefillTagObj, "document_tag_id", this.documentTagId);
        JsonUtils.addIfNotNull(prefillTagObj, "text_value", this.textValue);
        JsonUtils.addIfNotNull(prefillTagObj, "checkbox_value", this.checkboxValue);
        JsonUtils.addIfNotNull(prefillTagObj, "date_value", BoxDateFormat.formatAsDateOnly(this.dateValue));
        return prefillTagObj;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        try {
            if ("document_tag_id".equals(memberName)) {
                this.documentTagId = value.asString();
            } else if ("text_value".equals(memberName)) {
                this.textValue = value.asString();
            } else if ("checkbox_value".equals(memberName)) {
                this.checkboxValue = value.asBoolean();
            } else if ("date_value".equals(memberName)) {
                this.dateValue = BoxDateFormat.parseDateOnly(value.asString());
            }
        }
        catch (Exception e) {
            throw new BoxDeserializationException(memberName, value.toString(), e);
        }
    }
}

