/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxLogger;
import com.box.sdk.ProgressListener;
import com.box.sdk.ProgressOutputStream;
import com.box.sdk.StandardCharsets;
import com.box.sdk.UploadFileCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractBoxMultipartRequest
extends BoxAPIRequest {
    protected static final String BOUNDARY = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static final BoxLogger LOGGER = BoxLogger.defaultLogger();
    private static final int BUFFER_SIZE = 8192;
    private final StringBuilder loggedRequest = new StringBuilder();
    private final Map<String, String> fields = new HashMap<String, String>();
    private InputStream inputStream;
    private String filename;
    private long fileSize;
    private OutputStream outputStream;
    private UploadFileCallback callback;
    private boolean firstBoundary = true;

    AbstractBoxMultipartRequest(BoxAPIConnection api, URL url) {
        super(api, url, "POST");
        this.addHeader("Content-Type", "multipart/form-data; boundary=da39a3ee5e6b4b0d3255bfef95601890afd80709");
    }

    public void setFile(InputStream inputStream, String filename) {
        this.inputStream = inputStream;
        this.filename = filename;
    }

    public void setFile(InputStream inputStream, String filename, long fileSize) {
        this.setFile(inputStream, filename);
        this.fileSize = fileSize;
    }

    public void putField(String key, String value) {
        this.fields.put(key, value);
    }

    public void putField(String key, Date value) {
        this.fields.put(key, BoxDateFormat.format(value));
    }

    public void setUploadFileCallback(UploadFileCallback callback, String filename) {
        this.callback = callback;
        this.filename = filename;
    }

    public void setContentSHA1(String sha1) {
        this.addHeader("Content-MD5", sha1);
    }

    @Override
    public void setBody(InputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBody(String body) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeBody(HttpURLConnection connection, ProgressListener listener) {
        try {
            connection.setChunkedStreamingMode(0);
            connection.setDoOutput(true);
            this.outputStream = connection.getOutputStream();
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                this.writePartHeader(new String[][]{{"name", entry.getKey()}});
                this.writeOutput(entry.getValue());
            }
            this.writePartHeader(new String[][]{{"name", this.getPartName()}, {"filename", this.filename}}, this.getPartContentType(this.filename));
            OutputStream fileContentsOutputStream = this.outputStream;
            if (listener != null) {
                fileContentsOutputStream = new ProgressOutputStream(this.outputStream, listener, this.fileSize);
            }
            if (this.inputStream != null) {
                byte[] buffer = new byte[8192];
                int n = this.inputStream.read(buffer);
                while (n != -1) {
                    fileContentsOutputStream.write(buffer, 0, n);
                    n = this.inputStream.read(buffer);
                }
            } else {
                this.callback.writeToStream(this.outputStream);
            }
            if (LOGGER.isDebugEnabled()) {
                this.loggedRequest.append("<File Contents Omitted>");
            }
            this.writeBoundary();
            this.writeOutput("--");
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
    }

    protected abstract String getPartName();

    protected abstract String getPartContentType(String var1);

    @Override
    protected void resetBody() throws IOException {
        this.firstBoundary = true;
        this.inputStream.reset();
        this.loggedRequest.setLength(0);
    }

    @Override
    protected String bodyToString() {
        return this.loggedRequest.toString();
    }

    private void writeBoundary() throws IOException {
        if (!this.firstBoundary) {
            this.writeOutput("\r\n");
        }
        this.firstBoundary = false;
        this.writeOutput("--");
        this.writeOutput(BOUNDARY);
    }

    private void writePartHeader(String[][] formData) throws IOException {
        this.writePartHeader(formData, null);
    }

    private void writePartHeader(String[][] formData, String contentType) throws IOException {
        this.writeBoundary();
        this.writeOutput("\r\n");
        this.writeOutput("Content-Disposition: form-data");
        for (String[] part : formData) {
            this.writeOutput("; ");
            this.writeOutput(part[0]);
            this.writeOutput("=\"");
            this.writeOutput(URLEncoder.encode(part[1], "UTF-8"));
            this.writeOutput("\"");
        }
        if (contentType != null) {
            this.writeOutput("\r\nContent-Type: ");
            this.writeOutput(contentType);
        }
        this.writeOutput("\r\n\r\n");
    }

    private void writeOutput(String s) throws IOException {
        this.outputStream.write(s.getBytes(StandardCharsets.UTF_8));
        if (LOGGER.isDebugEnabled()) {
            this.loggedRequest.append(s);
        }
    }
}

