/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.ProgressListener;
import com.box.sdk.UploadFileCallback;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

abstract class AbstractBoxMultipartRequest
extends BoxAPIRequest {
    protected static final String BOUNDARY = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static final int BUFFER_SIZE = 8192;
    private final StringBuilder loggedRequest = new StringBuilder();
    private final Map<String, String> fields = new HashMap<String, String>();
    private InputStream inputStream;
    private String filename;
    private long fileSize;
    private UploadFileCallback callback;

    AbstractBoxMultipartRequest(BoxAPIConnection api, URL url) {
        super(api, url, "POST");
        this.addHeader("Content-Type", "multipart/form-data; boundary=da39a3ee5e6b4b0d3255bfef95601890afd80709");
    }

    public void setFile(InputStream inputStream, String filename) {
        this.inputStream = inputStream;
        this.filename = filename;
    }

    public void setFile(InputStream inputStream, String filename, long fileSize) {
        this.setFile(inputStream, filename);
        this.fileSize = fileSize;
    }

    public void putField(String key, String value) {
        this.fields.put(key, value);
    }

    public void putField(String key, Date value) {
        this.fields.put(key, BoxDateFormat.format(value));
    }

    public void setUploadFileCallback(UploadFileCallback callback, String filename) {
        this.callback = callback;
        this.filename = filename;
    }

    public void setContentSHA1(String sha1) {
        this.addHeader("Content-MD5", sha1);
    }

    @Override
    public void setBody(InputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBody(String body) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getPartName();

    protected abstract MediaType getPartContentType(String var1);

    @Override
    protected void resetBody() throws IOException {
        this.inputStream.reset();
        this.loggedRequest.setLength(0);
    }

    @Override
    protected String bodyToString() {
        return this.loggedRequest.toString();
    }

    @Override
    protected void writeMethodWithBody(Request.Builder requestBuilder, ProgressListener progressListener) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(this.getPartName(), this.filename, this.getBody(progressListener));
        this.fields.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)bodyBuilder).addFormDataPart(arg_0, arg_1));
        requestBuilder.post((RequestBody)bodyBuilder.build());
    }

    private RequestBody getBody(ProgressListener progressListener) {
        if (this.callback == null) {
            return new RequestBodyFromStream(this.inputStream, this.getPartContentType(this.filename), progressListener);
        }
        return new RequestBodyFromCallback(this.callback, this.getPartContentType(this.filename));
    }

    private static final class RequestBodyFromCallback
    extends RequestBody {
        private final UploadFileCallback callback;
        private final MediaType mediaType;

        private RequestBodyFromCallback(UploadFileCallback callback, MediaType mediaType) {
            this.callback = callback;
            this.mediaType = mediaType;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.callback.writeToStream(bufferedSink.outputStream());
        }
    }

    private static final class RequestBodyFromStream
    extends RequestBody {
        private final InputStream inputStream;
        private final ProgressListener progressListener;
        private final MediaType mediaType;
        private final int contentLength;

        private RequestBodyFromStream(InputStream inputStream, MediaType mediaType, ProgressListener progressListener) {
            this.inputStream = inputStream;
            this.progressListener = progressListener;
            this.mediaType = mediaType;
            try {
                this.contentLength = inputStream.available();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read input stream for upload", e);
            }
        }

        public long contentLength() {
            return this.contentLength;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            int n;
            byte[] buffer = new byte[8192];
            int totalWritten = n = this.inputStream.read(buffer);
            while (n != -1) {
                bufferedSink.write(buffer, 0, n);
                if (this.progressListener != null) {
                    this.progressListener.onProgressChanged(totalWritten, this.contentLength());
                }
                totalWritten += n;
                n = this.inputStream.read(buffer);
            }
        }
    }
}

