/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxSignRequestSignerRole;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BoxSignRequestSigner
extends BoxJSONObject {
    private String email;
    private BoxSignRequestSignerRole role;
    private Boolean isInPerson;
    private Integer order;
    private String embedUrlExternalUserId;
    private Boolean hasViewedEmail;
    private Boolean hasViewedDocument;
    private BoxSignerDecision signerDecision;
    private List<BoxSignerInput> inputs;
    private String embedUrl;
    private String redirectUrl;
    private String declinedRedirectUrl;
    private BoxAPIConnection api;

    public BoxSignRequestSigner(String email) {
        this.email = email;
    }

    public BoxSignRequestSigner(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    public String getEmail() {
        return this.email;
    }

    public BoxSignRequestSigner setEmail(String email) {
        this.email = email;
        return this;
    }

    public BoxSignRequestSignerRole getRole() {
        return this.role;
    }

    public BoxSignRequestSigner setRole(BoxSignRequestSignerRole role) {
        this.role = role;
        return this;
    }

    public boolean getIsInPerson() {
        return this.isInPerson;
    }

    public int getOrder() {
        return this.order;
    }

    public BoxSignRequestSigner setOrder(Integer order) {
        this.order = order;
        return this;
    }

    public String getEmbedUrlExternalUserId() {
        return this.embedUrlExternalUserId;
    }

    public BoxSignRequestSigner setEmbedUrlExternalUserId(String embedUrlExternalUserId) {
        this.embedUrlExternalUserId = embedUrlExternalUserId;
        return this;
    }

    public boolean getHasViewedEmail() {
        return this.hasViewedEmail;
    }

    public boolean getHasViewedDocument() {
        return this.hasViewedDocument;
    }

    public BoxSignerDecision getSignerDecision() {
        return this.signerDecision;
    }

    public List<BoxSignerInput> getInputs() {
        return this.inputs;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public Boolean getInPerson() {
        return this.isInPerson;
    }

    public BoxSignRequestSigner setInPerson(Boolean isInPerson) {
        this.isInPerson = isInPerson;
        return this;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public BoxSignRequestSigner setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public String getDeclinedRedirectUrl() {
        return this.declinedRedirectUrl;
    }

    public BoxSignRequestSigner setDeclinedRedirectUrl(String declinedRedirectUrl) {
        this.declinedRedirectUrl = declinedRedirectUrl;
        return this;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        try {
            switch (memberName) {
                case "email": {
                    this.email = value.asString();
                    break;
                }
                case "role": {
                    this.role = BoxSignRequestSignerRole.fromJSONString(value.asString());
                    break;
                }
                case "is_in_person": {
                    this.isInPerson = value.asBoolean();
                    break;
                }
                case "order": {
                    this.order = value.asInt();
                    break;
                }
                case "embed_url_external_user_id": {
                    this.embedUrlExternalUserId = value.asString();
                    break;
                }
                case "has_viewed_email": {
                    this.hasViewedEmail = value.asBoolean();
                    break;
                }
                case "has_viewed_document": {
                    this.hasViewedDocument = value.asBoolean();
                    break;
                }
                case "signer_decision": {
                    JsonObject signerDecisionJSON = value.asObject();
                    this.signerDecision = new BoxSignerDecision(signerDecisionJSON);
                    break;
                }
                case "inputs": {
                    ArrayList<BoxSignerInput> inputs = new ArrayList<BoxSignerInput>();
                    for (JsonValue inputJSON : value.asArray()) {
                        BoxSignerInput input = new BoxSignerInput(inputJSON.asObject());
                        inputs.add(input);
                    }
                    this.inputs = inputs;
                    break;
                }
                case "embed_url": {
                    this.embedUrl = value.asString();
                    break;
                }
                case "redirect_url": {
                    this.redirectUrl = value.asString();
                    break;
                }
                case "declined_redirect_url": {
                    this.declinedRedirectUrl = value.asString();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new BoxDeserializationException(memberName, value.toString(), e);
        }
    }

    public JsonObject getJSONObject() {
        JsonObject jsonObj = new JsonObject();
        JsonUtils.addIfNotNull(jsonObj, "email", this.email);
        JsonUtils.addIfNotNull(jsonObj, "role", this.role);
        JsonUtils.addIfNotNull(jsonObj, "is_in_person", this.isInPerson);
        JsonUtils.addIfNotNull(jsonObj, "order", this.order);
        JsonUtils.addIfNotNull(jsonObj, "embed_url_external_user_id", this.embedUrlExternalUserId);
        JsonUtils.addIfNotNull(jsonObj, "redirect_url", this.redirectUrl);
        JsonUtils.addIfNotNull(jsonObj, "declined_redirect_url", this.declinedRedirectUrl);
        return jsonObj;
    }

    public class BoxSignerInput
    extends BoxJSONObject {
        private String documentTagId;
        private String textValue;
        private boolean checkboxValue;
        private BoxSignRequestInputContentType contentType;
        private Date dateValue;
        private BoxSignRequestInputType type;
        private int pageIndex;

        public BoxSignerInput(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getDocumentTagId() {
            return this.documentTagId;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public boolean getIsCheckboxValue() {
            return this.checkboxValue;
        }

        public BoxSignRequestInputContentType getContentType() {
            return this.contentType;
        }

        public Date getDateValue() {
            return this.dateValue;
        }

        public BoxSignRequestInputType getType() {
            return this.type;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                switch (memberName) {
                    case "documentTagId": {
                        this.documentTagId = value.asString();
                        break;
                    }
                    case "text_value": {
                        this.textValue = value.asString();
                        break;
                    }
                    case "checkbox_value": {
                        this.checkboxValue = value.asBoolean();
                        break;
                    }
                    case "content_type": {
                        this.contentType = BoxSignRequestInputContentType.fromJSONString(value.asString());
                        break;
                    }
                    case "date_value": {
                        this.dateValue = BoxDateFormat.parseDateOnly(value.asString());
                        break;
                    }
                    case "type": {
                        this.type = BoxSignRequestInputType.fromJSONString(value.asString());
                        break;
                    }
                    case "page_index": {
                        this.pageIndex = value.asInt();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public class BoxSignerDecision
    extends BoxJSONObject {
        private BoxSignRequestSignerDecisionType type;
        private Date finalizedAt;

        public BoxSignerDecision(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxSignRequestSignerDecisionType getType() {
            return this.type;
        }

        public Date getFinalizedAt() {
            return this.finalizedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                if (memberName.equals("type")) {
                    this.type = BoxSignRequestSignerDecisionType.fromJSONString(value.asString());
                } else if (memberName.equals("finalized_at")) {
                    this.finalizedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static enum BoxSignRequestInputContentType {
        Initial("initial"),
        Stamp("stamp"),
        Signature("signature"),
        Company("company"),
        Title("title"),
        Email("email"),
        FullName("full_name"),
        FirstName("first_name"),
        LastName("last_name"),
        Text("text"),
        Date("date"),
        Checkbox("checkbox");

        private final String jsonValue;

        private BoxSignRequestInputContentType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestInputContentType fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "initial": {
                    return Initial;
                }
                case "stamp": {
                    return Stamp;
                }
                case "signature": {
                    return Signature;
                }
                case "company": {
                    return Company;
                }
                case "title": {
                    return Title;
                }
                case "email": {
                    return Email;
                }
                case "full_name": {
                    return FullName;
                }
                case "first_name": {
                    return FirstName;
                }
                case "last_name": {
                    return LastName;
                }
                case "text": {
                    return Text;
                }
                case "date": {
                    return Date;
                }
                case "checkbox": {
                    return Checkbox;
                }
            }
            throw new IllegalArgumentException(String.format("The provided JSON value '%s' isn't a valid BoxSignRequestInputContentType.", jsonValue));
        }
    }

    public static enum BoxSignRequestInputType {
        Signature("signature"),
        Text("text"),
        Checkbox("checkbox"),
        Date("date");

        private final String jsonValue;

        private BoxSignRequestInputType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestInputType fromJSONString(String jsonValue) {
            if ("signature".equals(jsonValue)) {
                return Signature;
            }
            if ("text".equals(jsonValue)) {
                return Text;
            }
            if ("checkbox".equals(jsonValue)) {
                return Checkbox;
            }
            if ("date".equals(jsonValue)) {
                return Date;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestInputType.");
        }
    }

    public static enum BoxSignRequestSignerDecisionType {
        Signed("signed"),
        Declined("declined");

        private final String jsonValue;

        private BoxSignRequestSignerDecisionType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignRequestSignerDecisionType fromJSONString(String jsonValue) {
            if ("signed".equals(jsonValue)) {
                return Signed;
            }
            if ("declined".equals(jsonValue)) {
                return Declined;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid BoxSignRequestSignerDecisionType.");
        }
    }
}

