/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;

public final class BoxDateFormat {
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMAT_SECONDS = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    });
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMAT_MILLISECONDS = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    });
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_ONLY = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    });

    private BoxDateFormat() {
    }

    public static Date parse(String dateString) throws ParseException {
        try {
            return THREAD_LOCAL_DATE_FORMAT_SECONDS.get().parse(dateString);
        }
        catch (ParseException pe) {
            return THREAD_LOCAL_DATE_FORMAT_MILLISECONDS.get().parse(dateString);
        }
    }

    public static Date parseDateOnly(String date) throws ParseException {
        return THREAD_LOCAL_DATE_ONLY.get().parse(date);
    }

    public static String format(Date date) {
        return THREAD_LOCAL_DATE_FORMAT_SECONDS.get().format(date);
    }

    public static String format(Instant instant) {
        return THREAD_LOCAL_DATE_FORMAT_SECONDS.get().format(Date.from(instant));
    }

    public static String formatAsDateOnly(Date date) {
        return THREAD_LOCAL_DATE_ONLY.get().format(date);
    }
}

