/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnectionListener;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxGlobalSettings;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.RequestInterceptor;
import com.box.sdk.ScopedToken;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class BoxAPIConnection {
    public static final X509TrustManager DEFAULT_TRUST_MANAGER = null;
    public static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = null;
    public static final int DEFAULT_MAX_RETRIES = 5;
    protected static final String DEFAULT_BASE_AUTHORIZATION_URL = "https://account.box.com/api/";
    static final String AS_USER_HEADER = "As-User";
    private static final String API_VERSION = "2.0";
    private static final String OAUTH_SUFFIX = "oauth2/authorize";
    private static final String TOKEN_URL_SUFFIX = "oauth2/token";
    private static final String REVOKE_URL_SUFFIX = "oauth2/revoke";
    private static final String DEFAULT_BASE_URL = "https://api.box.com/";
    private static final String DEFAULT_BASE_UPLOAD_URL = "https://upload.box.com/api/";
    private static final String DEFAULT_BASE_APP_URL = "https://app.box.com";
    private static final String BOX_NOTIFICATIONS_HEADER = "Box-Notifications";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String SDK_VERSION = "4.13.0";
    private static final long REFRESH_EPSILON = 60000L;
    private final String clientID;
    private final String clientSecret;
    private final ReadWriteLock refreshLock;
    private X509TrustManager trustManager;
    private HostnameVerifier hostnameVerifier;
    private volatile long lastRefresh;
    private volatile long expires;
    private Proxy proxy;
    private String proxyUsername;
    private String proxyPassword;
    private String userAgent;
    private String accessToken;
    private String refreshToken;
    private String tokenURL;
    private String revokeURL;
    private String baseURL;
    private String baseUploadURL;
    private String baseAppURL;
    private String baseAuthorizationURL;
    private boolean autoRefresh;
    private int maxRetryAttempts;
    private int connectTimeout;
    private int readTimeout;
    private final List<BoxAPIConnectionListener> listeners;
    private RequestInterceptor interceptor;
    private final Map<String, String> customHeaders;
    private OkHttpClient httpClient;
    private OkHttpClient noRedirectsHttpClient;
    private Authenticator authenticator;

    public BoxAPIConnection(String accessToken) {
        this(null, null, accessToken, null);
    }

    public BoxAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.baseURL = this.fixBaseUrl(DEFAULT_BASE_URL);
        this.baseUploadURL = this.fixBaseUrl(DEFAULT_BASE_UPLOAD_URL);
        this.baseAppURL = DEFAULT_BASE_APP_URL;
        this.baseAuthorizationURL = DEFAULT_BASE_AUTHORIZATION_URL;
        this.autoRefresh = true;
        this.maxRetryAttempts = BoxGlobalSettings.getMaxRetryAttempts();
        this.connectTimeout = BoxGlobalSettings.getConnectTimeout();
        this.readTimeout = BoxGlobalSettings.getReadTimeout();
        this.refreshLock = new ReentrantReadWriteLock();
        this.userAgent = "Box Java SDK v4.13.0 (Java " + JAVA_VERSION + ")";
        this.listeners = new ArrayList<BoxAPIConnectionListener>();
        this.customHeaders = new HashMap<String, String>();
        this.buildHttpClients();
    }

    public BoxAPIConnection(String clientID, String clientSecret, String authCode) {
        this(clientID, clientSecret, null, null);
        this.authenticate(authCode);
    }

    public BoxAPIConnection(String clientID, String clientSecret) {
        this(clientID, clientSecret, null, null);
    }

    public BoxAPIConnection(BoxConfig boxConfig) {
        this(boxConfig.getClientId(), boxConfig.getClientSecret(), null, null);
    }

    private void buildHttpClients() {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (this.trustManager != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{this.trustManager}, new SecureRandom());
                httpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), this.trustManager);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        OkHttpClient.Builder builder = httpClientBuilder.followSslRedirects(true).followRedirects(true).connectTimeout(Duration.ofMillis(this.connectTimeout)).readTimeout(Duration.ofMillis(this.readTimeout)).connectionSpecs(Collections.singletonList(ConnectionSpec.MODERN_TLS));
        if (this.hostnameVerifier != null) {
            httpClientBuilder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)this.proxyUsername, (String)this.proxyPassword);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
            if (this.authenticator != null) {
                builder.proxyAuthenticator(this.authenticator);
            }
        }
        builder = this.modifyHttpClientBuilder(builder);
        this.httpClient = builder.build();
        this.noRedirectsHttpClient = new OkHttpClient.Builder(this.httpClient).followSslRedirects(false).followRedirects(false).build();
    }

    protected OkHttpClient.Builder modifyHttpClientBuilder(OkHttpClient.Builder httpClientBuilder) {
        return httpClientBuilder;
    }

    public void setProxyAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.buildHttpClients();
    }

    public static BoxAPIConnection restore(String clientID, String clientSecret, String state) {
        BoxAPIConnection api = new BoxAPIConnection(clientID, clientSecret);
        api.restore(state);
        return api;
    }

    public static URL getAuthorizationURL(String clientID, URI redirectUri, String state, List<String> scopes) {
        return BoxAPIConnection.createFullAuthorizationUrl(DEFAULT_BASE_AUTHORIZATION_URL, clientID, redirectUri, state, scopes);
    }

    private static URL createFullAuthorizationUrl(String authorizationUrl, String clientID, URI redirectUri, String state, List<String> scopes) {
        URLTemplate template = new URLTemplate(authorizationUrl + OAUTH_SUFFIX);
        QueryStringBuilder queryBuilder = new QueryStringBuilder().appendParam("client_id", clientID).appendParam("response_type", "code").appendParam("redirect_uri", redirectUri.toString()).appendParam("state", state);
        if (scopes != null && !scopes.isEmpty()) {
            queryBuilder.appendParam("scope", String.join((CharSequence)" ", scopes));
        }
        return template.buildWithQuery("", queryBuilder.toString(), new Object[0]);
    }

    public void authenticate(String authCode) {
        URL url;
        try {
            url = new URL(this.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("grant_type=authorization_code&code=%s&client_id=%s&client_secret=%s", authCode, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        try (BoxJSONResponse response = (BoxJSONResponse)request.send();){
            String json = response.getJSON();
            JsonObject jsonObject = Json.parse((String)json).asObject();
            this.accessToken = jsonObject.get("access_token").asString();
            this.refreshToken = jsonObject.get("refresh_token").asString();
            this.lastRefresh = System.currentTimeMillis();
            this.expires = jsonObject.get("expires_in").asLong() * 1000L;
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long milliseconds) {
        this.expires = milliseconds;
    }

    public String getTokenURL() {
        if (this.tokenURL != null) {
            return this.tokenURL;
        }
        return this.baseURL + TOKEN_URL_SUFFIX;
    }

    public String getRevokeURL() {
        if (this.revokeURL != null) {
            return this.revokeURL;
        }
        return this.baseURL + REVOKE_URL_SUFFIX;
    }

    public String getBaseURL() {
        return this.baseURL + API_VERSION + "/";
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = this.fixBaseUrl(baseURL);
    }

    public String getBaseUploadURL() {
        return this.baseUploadURL + API_VERSION + "/";
    }

    public void setBaseUploadURL(String baseUploadURL) {
        this.baseUploadURL = this.fixBaseUrl(baseUploadURL);
    }

    public URL getAuthorizationURL(URI redirectUri, String state, List<String> scopes) {
        return BoxAPIConnection.createFullAuthorizationUrl(this.baseAuthorizationURL, this.clientID, redirectUri, state, scopes);
    }

    public void setBaseAuthorizationURL(String baseAuthorizationURL) {
        this.baseAuthorizationURL = this.fixBaseUrl(baseAuthorizationURL);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getBaseAppUrl() {
        return this.baseAppURL;
    }

    public void setBaseAppUrl(String baseAppURL) {
        this.baseAppURL = baseAppURL;
    }

    public String getAccessToken() {
        if (this.autoRefresh && this.canRefresh() && this.needsRefresh()) {
            this.refreshLock.writeLock().lock();
            try {
                if (this.needsRefresh()) {
                    this.refresh();
                }
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        }
        this.refreshLock.readLock().lock();
        try {
            String string = this.accessToken;
            return string;
        }
        finally {
            this.refreshLock.readLock().unlock();
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    protected ReadWriteLock getRefreshLock() {
        return this.refreshLock;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int attempts) {
        this.maxRetryAttempts = attempts;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.buildHttpClients();
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.buildHttpClients();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
        this.buildHttpClients();
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        this.buildHttpClients();
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyBasicAuthentication(String proxyUsername, String proxyPassword) {
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.buildHttpClients();
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        this.buildHttpClients();
    }

    public boolean canRefresh() {
        return this.refreshToken != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsRefresh() {
        boolean needsRefresh;
        this.refreshLock.readLock().lock();
        try {
            long now = System.currentTimeMillis();
            long tokenDuration = now - this.lastRefresh;
            needsRefresh = tokenDuration >= this.expires - 60000L;
        }
        finally {
            this.refreshLock.readLock().unlock();
        }
        return needsRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.refreshLock.writeLock().lock();
        try {
            String json;
            URL url;
            if (!this.canRefresh()) {
                throw new IllegalStateException("The BoxAPIConnection cannot be refreshed because it doesn't have a refresh token.");
            }
            try {
                url = new URL(this.getTokenURL());
            }
            catch (MalformedURLException e) {
                assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
                throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
            }
            BoxAPIRequest request = this.createTokenRequest(url);
            try (BoxAPIResponse boxAPIResponse = request.send();){
                BoxJSONResponse response = (BoxJSONResponse)boxAPIResponse;
                json = response.getJSON();
            }
            catch (BoxAPIException e) {
                this.notifyError(e);
                throw e;
            }
            this.extractTokens(Json.parse((String)json).asObject());
            this.notifyRefresh();
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
    }

    public void restore(String state) {
        JsonObject json = Json.parse((String)state).asObject();
        String accessToken = json.get("accessToken").asString();
        String refreshToken = this.getKeyValueOrDefault(json, "refreshToken", null);
        long lastRefresh = json.get("lastRefresh").asLong();
        long expires = json.get("expires").asLong();
        String userAgent = json.get("userAgent").asString();
        String tokenURL = this.getKeyValueOrDefault(json, "tokenURL", null);
        String revokeURL = this.getKeyValueOrDefault(json, "revokeURL", null);
        String baseURL = this.adoptBaseUrlWhenLoadingFromOldVersion(this.getKeyValueOrDefault(json, "baseURL", DEFAULT_BASE_URL));
        String baseUploadURL = this.adoptUploadBaseUrlWhenLoadingFromOldVersion(this.getKeyValueOrDefault(json, "baseUploadURL", DEFAULT_BASE_UPLOAD_URL));
        String authorizationURL = this.getKeyValueOrDefault(json, "authorizationURL", DEFAULT_BASE_AUTHORIZATION_URL);
        boolean autoRefresh = json.get("autoRefresh").asBoolean();
        int maxRequestAttempts = -1;
        if (json.names().contains("maxRequestAttempts")) {
            maxRequestAttempts = json.get("maxRequestAttempts").asInt();
        }
        int maxRetryAttempts = -1;
        if (json.names().contains("maxRetryAttempts")) {
            maxRetryAttempts = json.get("maxRetryAttempts").asInt();
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.lastRefresh = lastRefresh;
        this.expires = expires;
        this.userAgent = userAgent;
        this.tokenURL = tokenURL;
        this.revokeURL = revokeURL;
        this.setBaseURL(baseURL);
        this.setBaseUploadURL(baseUploadURL);
        this.setBaseAuthorizationURL(authorizationURL);
        this.autoRefresh = autoRefresh;
        if (maxRequestAttempts > -1) {
            this.maxRetryAttempts = maxRequestAttempts - 1;
        }
        if (maxRetryAttempts > -1) {
            this.maxRetryAttempts = maxRetryAttempts;
        }
    }

    private String adoptBaseUrlWhenLoadingFromOldVersion(String url) {
        if (url == null) {
            return null;
        }
        String urlEndingWithSlash = this.fixBaseUrl(url);
        return urlEndingWithSlash.equals("https://api.box.com/2.0/") ? DEFAULT_BASE_URL : urlEndingWithSlash;
    }

    private String adoptUploadBaseUrlWhenLoadingFromOldVersion(String url) {
        if (url == null) {
            return null;
        }
        String urlEndingWithSlash = this.fixBaseUrl(url);
        return urlEndingWithSlash.equals("https://upload.box.com/api/2.0/") ? DEFAULT_BASE_UPLOAD_URL : urlEndingWithSlash;
    }

    protected String getKeyValueOrDefault(JsonObject json, String key, String defaultValue) {
        return Optional.ofNullable(json.get(key)).filter(js -> !js.isNull()).map(JsonValue::asString).orElse(defaultValue);
    }

    protected void notifyRefresh() {
        for (BoxAPIConnectionListener listener : this.listeners) {
            listener.onRefresh(this);
        }
    }

    protected void notifyError(BoxAPIException error) {
        for (BoxAPIConnectionListener listener : this.listeners) {
            listener.onError(this, error);
        }
    }

    public void addListener(BoxAPIConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BoxAPIConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.interceptor;
    }

    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public ScopedToken getLowerScopedToken(List<String> scopes, String resource) {
        String jsonResponse;
        URL url;
        assert (scopes != null);
        assert (scopes.size() > 0);
        try {
            url = new URL(this.getTokenURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new BoxAPIException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        StringBuilder spaceSeparatedScopes = this.buildScopesForTokenDownscoping(scopes);
        String urlParameters = String.format("grant_type=urn:ietf:params:oauth:grant-type:token-exchange&subject_token_type=urn:ietf:params:oauth:token-type:access_token&subject_token=%s&scope=%s", this.getAccessToken(), spaceSeparatedScopes);
        if (resource != null) {
            ResourceLinkType resourceType = this.determineResourceLinkType(resource);
            if (resourceType == ResourceLinkType.APIEndpoint) {
                urlParameters = String.format(urlParameters + "&resource=%s", resource);
            } else if (resourceType == ResourceLinkType.SharedLink) {
                urlParameters = String.format(urlParameters + "&box_shared_link=%s", resource);
            } else {
                if (resourceType == ResourceLinkType.Unknown) {
                    String argExceptionMessage = String.format("Unable to determine resource type: %s", resource);
                    BoxAPIException e = new BoxAPIException(argExceptionMessage);
                    this.notifyError(e);
                    throw e;
                }
                String argExceptionMessage = String.format("Unhandled resource type: %s", resource);
                BoxAPIException e = new BoxAPIException(argExceptionMessage);
                this.notifyError(e);
                throw e;
            }
        }
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        try (BoxJSONResponse response = (BoxJSONResponse)request.send();){
            jsonResponse = response.getJSON();
        }
        catch (BoxAPIException e) {
            this.notifyError(e);
            throw e;
        }
        JsonObject jsonObject = Json.parse((String)jsonResponse).asObject();
        ScopedToken token = new ScopedToken(jsonObject);
        token.setObtainedAt(System.currentTimeMillis());
        token.setExpiresIn(jsonObject.get("expires_in").asLong() * 1000L);
        return token;
    }

    private StringBuilder buildScopesForTokenDownscoping(List<String> scopes) {
        StringBuilder spaceSeparatedScopes = new StringBuilder();
        for (int i = 0; i < scopes.size(); ++i) {
            spaceSeparatedScopes.append(scopes.get(i));
            if (i >= scopes.size() - 1) continue;
            spaceSeparatedScopes.append(" ");
        }
        return spaceSeparatedScopes;
    }

    protected ResourceLinkType determineResourceLinkType(String resourceLink) {
        ResourceLinkType resourceType = ResourceLinkType.Unknown;
        try {
            URL validUrl = new URL(resourceLink);
            String validURLStr = validUrl.toString();
            String apiFilesEndpointPattern = ".*box.com/2.0/files/\\d+";
            String apiFoldersEndpointPattern = ".*box.com/2.0/folders/\\d+";
            String sharedLinkPattern = "(.*box.com/s/.*|.*box.com.*s=.*)";
            if (Pattern.matches(".*box.com/2.0/files/\\d+", validURLStr) || Pattern.matches(".*box.com/2.0/folders/\\d+", validURLStr)) {
                resourceType = ResourceLinkType.APIEndpoint;
            } else if (Pattern.matches("(.*box.com/s/.*|.*box.com.*s=.*)", validURLStr)) {
                resourceType = ResourceLinkType.SharedLink;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resourceType;
    }

    public void revokeToken() {
        URL url;
        try {
            url = new URL(this.getRevokeURL());
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("token=%s&client_id=%s&client_secret=%s", this.accessToken, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        request.send().close();
    }

    public String save() {
        JsonObject state = new JsonObject().add("accessToken", this.accessToken).add("refreshToken", this.refreshToken).add("lastRefresh", this.lastRefresh).add("expires", this.expires).add("userAgent", this.userAgent).add("tokenURL", this.tokenURL).add("revokeURL", this.revokeURL).add("baseURL", this.baseURL).add("baseUploadURL", this.baseUploadURL).add("authorizationURL", this.baseAuthorizationURL).add("autoRefresh", this.autoRefresh).add("maxRetryAttempts", this.maxRetryAttempts);
        return state.toString();
    }

    String lockAccessToken() {
        if (this.autoRefresh && this.canRefresh() && this.needsRefresh()) {
            this.refreshLock.writeLock().lock();
            try {
                if (this.needsRefresh()) {
                    this.refresh();
                }
                this.refreshLock.readLock().lock();
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        } else {
            this.refreshLock.readLock().lock();
        }
        return this.accessToken;
    }

    void unlockAccessToken() {
        this.refreshLock.readLock().unlock();
    }

    String getBoxUAHeader() {
        return "agent=box-java-sdk/4.13.0; env=Java/" + JAVA_VERSION;
    }

    public void setCustomHeader(String header, String value) {
        this.customHeaders.put(header, value);
    }

    public void removeCustomHeader(String header) {
        this.customHeaders.remove(header);
    }

    public void suppressNotifications() {
        this.setCustomHeader(BOX_NOTIFICATIONS_HEADER, "off");
    }

    public void enableNotifications() {
        this.removeCustomHeader(BOX_NOTIFICATIONS_HEADER);
    }

    public void asUser(String userID) {
        this.setCustomHeader(AS_USER_HEADER, userID);
    }

    public void asSelf() {
        this.removeCustomHeader(AS_USER_HEADER);
    }

    public void configureSslCertificatesValidation(X509TrustManager trustManager, HostnameVerifier hostnameVerifier) {
        this.trustManager = trustManager;
        this.hostnameVerifier = hostnameVerifier;
        this.buildHttpClients();
    }

    Map<String, String> getHeaders() {
        return this.customHeaders;
    }

    protected void extractTokens(JsonObject jsonObject) {
        this.accessToken = jsonObject.get("access_token").asString();
        this.refreshToken = jsonObject.get("refresh_token").asString();
        this.lastRefresh = System.currentTimeMillis();
        this.expires = jsonObject.get("expires_in").asLong() * 1000L;
    }

    protected BoxAPIRequest createTokenRequest(URL url) {
        String urlParameters = String.format("grant_type=refresh_token&refresh_token=%s&client_id=%s&client_secret=%s", this.refreshToken, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(this, url, "POST");
        request.shouldAuthenticate(false);
        request.setBody(urlParameters);
        return request;
    }

    private String fixBaseUrl(String baseUrl) {
        return baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    Response execute(Request request) {
        return this.executeOnClient(this.httpClient, request);
    }

    Response executeWithoutRedirect(Request request) {
        return this.executeOnClient(this.noRedirectsHttpClient, request);
    }

    protected Call createNewCall(OkHttpClient httpClient, Request request) {
        return httpClient.newCall(request);
    }

    private Response executeOnClient(OkHttpClient httpClient, Request request) {
        try {
            return this.createNewCall(httpClient, request).execute();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error. Request\n" + request, e);
        }
    }

    protected X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    protected HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    protected static enum ResourceLinkType {
        Unknown,
        APIEndpoint,
        SharedLink;

    }
}

