/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxResource;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;

public abstract class BoxCollaborator
extends BoxResource {
    public BoxCollaborator(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public abstract class Info
    extends BoxResource.Info {
        private CollaboratorType type;
        private String name;
        private Date createdAt;
        private Date modifiedAt;
        private String login;
        private GroupType groupType;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public CollaboratorType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.addPendingChange("name", name);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public String getLogin() {
            return this.login;
        }

        public GroupType getGroupType() {
            return this.groupType;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String name = member.getName();
            try {
                switch (name) {
                    case "type": {
                        this.type = CollaboratorType.fromJSONValue(value.asString());
                        break;
                    }
                    case "name": {
                        this.name = value.asString();
                        break;
                    }
                    case "created_at": {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "modified_at": {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "login": {
                        this.login = value.asString();
                        break;
                    }
                    case "group_type": {
                        this.groupType = GroupType.fromJSONValue(value.asString());
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(name, value.toString(), e);
            }
        }
    }

    public static enum GroupType {
        ALL_USERS_GROUP("all_users_group"),
        MANAGED_GROUP("managed_group");

        private final String jsonValue;

        private GroupType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static GroupType fromJSONValue(String jsonValue) {
            return GroupType.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum CollaboratorType {
        USER("user"),
        GROUP("group");

        private final String jsonValue;

        private CollaboratorType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static CollaboratorType fromJSONValue(String jsonValue) {
            return CollaboratorType.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }
}

