/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIResponse;
import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class BinaryBodyUtils {
    private static final int BUFFER_SIZE = 8192;

    private BinaryBodyUtils() {
    }

    static void writeStream(BoxAPIResponse response, OutputStream output) {
        BinaryBodyUtils.writeStream(response, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeStream(BoxAPIResponse response, OutputStream output, ProgressListener listener) {
        try {
            InputStream input = listener != null ? response.getBody(listener) : response.getBody();
            BinaryBodyUtils.writeStreamTo(input, output);
        }
        finally {
            response.close();
        }
    }

    static void writeStreamWithContentLength(BoxAPIResponse response, OutputStream output) {
        BinaryBodyUtils.writeStreamWithContentLength(response, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeStreamWithContentLength(BoxAPIResponse response, OutputStream output, ProgressListener listener) {
        try {
            InputStream input = listener != null ? response.getBody(listener) : response.getBody();
            BinaryBodyUtils.writeStreamTo(input, output, BinaryBodyUtils.getContentLengthFromAPIResponse(response));
        }
        finally {
            response.close();
        }
    }

    private static long getContentLengthFromAPIResponse(BoxAPIResponse response) {
        long length = response.getContentLength();
        if (length == -1L) {
            String headerValue = null;
            if (response.getHeaders().containsKey("Content-Length")) {
                headerValue = response.getHeaders().get("Content-Length").get(0);
            } else if (response.getHeaders().containsKey("X-Original-Content-Length")) {
                headerValue = response.getHeaders().get("X-Original-Content-Length").get(0);
            }
            if (headerValue != null) {
                try {
                    length = Long.parseLong(headerValue);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid content length: " + headerValue);
                }
            }
        }
        return length;
    }

    static void writeStreamTo(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[8192];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void writeStreamTo(InputStream input, OutputStream output, long expectedLength) {
        long totalBytesRead = 0L;
        if (expectedLength < 0L) {
            throw new RuntimeException("Expected content length should not be negative: " + expectedLength);
        }
        try {
            byte[] buffer = new byte[8192];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                totalBytesRead += (long)n;
                n = input.read(buffer);
            }
            if (totalBytesRead != expectedLength) {
                throw new IOException("Stream ended prematurely. Expected " + expectedLength + " bytes, but read " + totalBytesRead + " bytes.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error during streaming: " + e.getMessage(), e);
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (IOException closeException) {
                throw new RuntimeException("IOException during stream close", closeException);
            }
        }
    }
}

