/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxSignRequestSignerRole;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BoxSignTemplateSigner
extends BoxJSONObject {
    private String email;
    private List<BoxSignTemplateSignerInput> inputs;
    private Boolean isInPerson;
    private int order;
    private BoxSignRequestSignerRole role;
    private String signerGroupId;
    private BoxAPIConnection api;

    public BoxSignTemplateSigner(String email, List<BoxSignTemplateSignerInput> inputs, Boolean isInPerson, int order, BoxSignRequestSignerRole role) {
        this(email, inputs, isInPerson, order, role, null);
    }

    public BoxSignTemplateSigner(String email, List<BoxSignTemplateSignerInput> inputs, Boolean isInPerson, int order, BoxSignRequestSignerRole role, String signerGroupId) {
        this.email = email;
        this.inputs = inputs;
        this.isInPerson = isInPerson;
        this.order = order;
        this.role = role;
        this.signerGroupId = signerGroupId;
    }

    public BoxSignTemplateSigner(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    public String getEmail() {
        return this.email;
    }

    public List<BoxSignTemplateSignerInput> getInputs() {
        return this.inputs;
    }

    public Boolean getIsInPerson() {
        return this.isInPerson;
    }

    public int getOrder() {
        return this.order;
    }

    public BoxSignRequestSignerRole getRole() {
        return this.role;
    }

    public String getSignerGroupId() {
        return this.signerGroupId;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        try {
            switch (memberName) {
                case "email": {
                    this.email = value.asString();
                    break;
                }
                case "inputs": {
                    this.inputs = new ArrayList<BoxSignTemplateSignerInput>();
                    for (JsonValue inputJSON : value.asArray()) {
                        this.inputs.add(new BoxSignTemplateSignerInput(inputJSON.asObject(), this.api));
                    }
                    break;
                }
                case "is_in_person": {
                    this.isInPerson = value.asBoolean();
                    break;
                }
                case "order": {
                    this.order = value.asInt();
                    break;
                }
                case "role": {
                    this.role = BoxSignRequestSignerRole.fromJSONString(value.asString());
                    break;
                }
                case "signer_group_id": {
                    this.signerGroupId = value.asString();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new BoxDeserializationException(memberName, value.toString(), e);
        }
    }

    public static enum BoxSignTemplateSignerInputContentType {
        Initial("initial"),
        Stamp("stamp"),
        Signature("signature"),
        Company("company"),
        Title("title"),
        Email("email"),
        FullName("full_name"),
        FirstName("first_name"),
        LastName("last_name"),
        Text("text"),
        Date("date"),
        Checkbox("checkbox"),
        Attachement("attachment"),
        Radio("radio"),
        Dropdown("dropdown");

        private final String jsonValue;

        private BoxSignTemplateSignerInputContentType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignTemplateSignerInputContentType fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "initial": {
                    return Initial;
                }
                case "stamp": {
                    return Stamp;
                }
                case "signature": {
                    return Signature;
                }
                case "company": {
                    return Company;
                }
                case "title": {
                    return Title;
                }
                case "email": {
                    return Email;
                }
                case "full_name": {
                    return FullName;
                }
                case "first_name": {
                    return FirstName;
                }
                case "last_name": {
                    return LastName;
                }
                case "text": {
                    return Text;
                }
                case "date": {
                    return Date;
                }
                case "checkbox": {
                    return Checkbox;
                }
                case "attachment": {
                    return Attachement;
                }
                case "radio": {
                    return Radio;
                }
                case "dropdown": {
                    return Dropdown;
                }
            }
            throw new IllegalArgumentException(String.format("The provided JSON value '%s' isn't a valid BoxSignTemplateSignerInputContentType.", jsonValue));
        }
    }

    public static enum BoxSignTemplateSignerInputType {
        Signature("signature"),
        Date("date"),
        Text("text"),
        Checkbox("checkbox"),
        Attachment("attachment"),
        Radio("radio"),
        Dropdown("dropdown");

        private final String jsonValue;

        private BoxSignTemplateSignerInputType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static BoxSignTemplateSignerInputType fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "signature": {
                    return Signature;
                }
                case "date": {
                    return Date;
                }
                case "text": {
                    return Text;
                }
                case "checkbox": {
                    return Checkbox;
                }
                case "attachment": {
                    return Attachment;
                }
                case "radio": {
                    return Radio;
                }
                case "dropdown": {
                    return Dropdown;
                }
            }
            throw new IllegalArgumentException(String.format("The provided JSON value '%s' isn't a valid BoxSignTemplateSignerInputType.", jsonValue));
        }
    }

    public class BoxSignTemplatesSignerInputDimensions {
        private final double height;
        private final double width;

        public BoxSignTemplatesSignerInputDimensions(double height, double width) {
            this.height = height;
            this.width = width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }
    }

    public class BoxSignTemplateSignerInputCoordinates {
        private final double x;
        private final double y;

        public BoxSignTemplateSignerInputCoordinates(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    public class BoxSignTemplateSignerInput
    extends BoxJSONObject {
        private BoxSignTemplateSignerInputType type;
        private Boolean checkboxValue;
        private BoxSignTemplateSignerInputContentType contentType;
        private BoxSignTemplateSignerInputCoordinates coordinates;
        private Date dateValue;
        private BoxSignTemplatesSignerInputDimensions dimensions;
        private String documentId;
        private String documentTagId;
        private List<String> dropdownChoices;
        private String groupId;
        private Boolean isRequired;
        private int pageIndex;
        private String textValue;
        private String label;
        private BoxAPIConnection api;

        public BoxSignTemplateSignerInput(BoxSignTemplateSignerInputType type, Boolean checkboxValue, BoxSignTemplateSignerInputContentType contentType, BoxSignTemplateSignerInputCoordinates coordinates, Date dateValue, BoxSignTemplatesSignerInputDimensions dimensions, String documentId, String documentTagId, List<String> dropdownChoices, String groupId, Boolean isRequired, int pageIndex, String textValue, String label) {
            this.type = type;
            this.checkboxValue = checkboxValue;
            this.contentType = contentType;
            this.coordinates = coordinates;
            this.dateValue = dateValue;
            this.dimensions = dimensions;
            this.documentId = documentId;
            this.documentTagId = documentTagId;
            this.dropdownChoices = dropdownChoices;
            this.groupId = groupId;
            this.isRequired = isRequired;
            this.pageIndex = pageIndex;
            this.textValue = textValue;
            this.label = label;
        }

        public BoxSignTemplateSignerInput(JsonObject jsonObject, BoxAPIConnection api) {
            super(jsonObject);
            this.api = api;
        }

        public BoxSignTemplateSignerInputType getType() {
            return this.type;
        }

        public Boolean getCheckboxValue() {
            return this.checkboxValue;
        }

        public BoxSignTemplateSignerInputContentType getContentType() {
            return this.contentType;
        }

        public BoxSignTemplateSignerInputCoordinates getCoordinates() {
            return this.coordinates;
        }

        public Date getDateValue() {
            return this.dateValue;
        }

        public BoxSignTemplatesSignerInputDimensions getDimensions() {
            return this.dimensions;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getDocumentTagId() {
            return this.documentTagId;
        }

        public List<String> getDropdownChoices() {
            return this.dropdownChoices;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public Boolean getIsRequired() {
            return this.isRequired;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                switch (memberName) {
                    case "type": {
                        this.type = BoxSignTemplateSignerInputType.fromJSONString(value.asString());
                        break;
                    }
                    case "checkbox_value": {
                        this.checkboxValue = value.asBoolean();
                        break;
                    }
                    case "content_type": {
                        this.contentType = BoxSignTemplateSignerInputContentType.fromJSONString(value.asString());
                        break;
                    }
                    case "coordinates": {
                        JsonObject coordinatesJSON = value.asObject();
                        double x = coordinatesJSON.get("x").asFloat();
                        double y = coordinatesJSON.get("y").asFloat();
                        this.coordinates = new BoxSignTemplateSignerInputCoordinates(x, y);
                        break;
                    }
                    case "date_value": {
                        this.dateValue = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "dimensions": {
                        JsonObject dimensionsJSON = value.asObject();
                        double height = dimensionsJSON.get("height").asFloat();
                        double width = dimensionsJSON.get("width").asFloat();
                        this.dimensions = new BoxSignTemplatesSignerInputDimensions(height, width);
                        break;
                    }
                    case "document_id": {
                        this.documentId = value.asString();
                        break;
                    }
                    case "document_tag_id": {
                        this.documentTagId = value.asString();
                        break;
                    }
                    case "dropdown_choices": {
                        this.dropdownChoices = new ArrayList<String>();
                        for (JsonValue choiceJSON : value.asArray()) {
                            this.dropdownChoices.add(choiceJSON.asString());
                        }
                        break;
                    }
                    case "group_id": {
                        this.groupId = value.asString();
                        break;
                    }
                    case "is_required": {
                        this.isRequired = value.asBoolean();
                        break;
                    }
                    case "page_index": {
                        this.pageIndex = value.asInt();
                        break;
                    }
                    case "text_value": {
                        this.textValue = value.asString();
                        break;
                    }
                    case "label": {
                        this.label = value.asString();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

