/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxClassification;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxFolderLock;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxItemIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxMetadataCascadePolicy;
import com.box.sdk.BoxMultipartRequest;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxUploadEmail;
import com.box.sdk.BoxUser;
import com.box.sdk.BoxWatermark;
import com.box.sdk.BoxWebHook;
import com.box.sdk.BoxWebLink;
import com.box.sdk.FileUploadParams;
import com.box.sdk.LargeFileUpload;
import com.box.sdk.Metadata;
import com.box.sdk.PagingParameters;
import com.box.sdk.PartialCollection;
import com.box.sdk.ProgressListener;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.SortParameters;
import com.box.sdk.URLTemplate;
import com.box.sdk.UploadFileCallback;
import com.box.sdk.internal.utils.Parsers;
import com.box.sdk.sharedlink.BoxSharedLinkRequest;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@BoxResourceType(value="folder")
public class BoxFolder
extends BoxItem
implements Iterable<BoxItem.Info> {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "created_at", "modified_at", "description", "size", "path_collection", "created_by", "modified_by", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "owned_by", "shared_link", "folder_upload_email", "parent", "item_status", "item_collection", "sync_state", "has_collaborations", "permissions", "tags", "can_non_owners_invite", "collections", "watermark_info", "metadata", "is_externally_owned", "is_collaboration_restricted_to_enterprise", "allowed_shared_link_access_levels", "allowed_invitee_roles", "is_accessible_via_shared_link", "can_non_owners_view_collaborators"};
    public static final URLTemplate CREATE_FOLDER_URL = new URLTemplate("folders");
    public static final URLTemplate CREATE_WEB_LINK_URL = new URLTemplate("web_links");
    public static final URLTemplate COPY_FOLDER_URL = new URLTemplate("folders/%s/copy");
    public static final URLTemplate DELETE_FOLDER_URL = new URLTemplate("folders/%s?recursive=%b");
    public static final URLTemplate FOLDER_INFO_URL_TEMPLATE = new URLTemplate("folders/%s");
    public static final URLTemplate UPLOAD_FILE_URL = new URLTemplate("files/content");
    public static final URLTemplate ADD_COLLABORATION_URL = new URLTemplate("collaborations");
    public static final URLTemplate GET_COLLABORATIONS_URL = new URLTemplate("folders/%s/collaborations");
    public static final URLTemplate GET_ITEMS_URL = new URLTemplate("folders/%s/items/");
    public static final URLTemplate SEARCH_URL_TEMPLATE = new URLTemplate("search");
    public static final URLTemplate METADATA_URL_TEMPLATE = new URLTemplate("folders/%s/metadata/%s/%s");
    public static final URLTemplate UPLOAD_SESSION_URL_TEMPLATE = new URLTemplate("files/upload_sessions");
    public static final URLTemplate FOLDER_LOCK_URL_TEMPLATE = new URLTemplate("folder_locks");
    static final String TYPE = "folder";

    public BoxFolder(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static BoxFolder getRootFolder(BoxAPIConnection api) {
        return new BoxFolder(api, "0");
    }

    @Override
    protected URL getItemURL() {
        return FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("id", collaborator.getID());
        if (collaborator instanceof BoxUser) {
            accessibleByField.add("type", "user");
        } else if (collaborator instanceof BoxGroup) {
            accessibleByField.add("type", "group");
        } else {
            throw new IllegalArgumentException("The given collaborator is of an unknown type.");
        }
        return this.collaborate(accessibleByField, role, null, null, null, null);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("login", email);
        accessibleByField.add("type", "user");
        return this.collaborate(accessibleByField, role, null, null, null, null);
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath, Date expiresAt, Boolean isAccessOnly) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("id", collaborator.getID());
        if (collaborator instanceof BoxUser) {
            accessibleByField.add("type", "user");
        } else if (collaborator instanceof BoxGroup) {
            accessibleByField.add("type", "group");
        } else {
            throw new IllegalArgumentException("The given collaborator is of an unknown type.");
        }
        return this.collaborate(accessibleByField, role, notify, canViewPath, expiresAt, isAccessOnly);
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        return this.collaborate(collaborator, role, notify, canViewPath, null, null);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath, Date expiresAt, Boolean isAccessOnly) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("login", email);
        accessibleByField.add("type", "user");
        return this.collaborate(accessibleByField, role, notify, canViewPath, expiresAt, isAccessOnly);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        return this.collaborate(email, role, notify, canViewPath, null, null);
    }

    private BoxCollaboration.Info collaborate(JsonObject accessibleByField, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath, Date expiresAt, Boolean isAccessOnly) {
        JsonObject itemField = new JsonObject();
        itemField.add("id", this.getID());
        itemField.add("type", TYPE);
        return BoxCollaboration.create(this.getAPI(), accessibleByField, itemField, role, notify, canViewPath, expiresAt, isAccessOnly);
    }

    public BoxSharedLink createSharedLink(BoxSharedLinkRequest sharedLinkRequest) {
        return this.createSharedLink(sharedLinkRequest.asSharedLink());
    }

    private BoxSharedLink createSharedLink(BoxSharedLink sharedLink) {
        Info info = new Info();
        info.setSharedLink(this.removeCanEditPermissionIfSet(sharedLink));
        this.updateInfo(info);
        return info.getSharedLink();
    }

    private BoxSharedLink removeCanEditPermissionIfSet(BoxSharedLink sharedLink) {
        if (sharedLink.getPermissions() != null && sharedLink.getPermissions().getCanEdit()) {
            BoxSharedLink.Permissions permissions = sharedLink.getPermissions();
            sharedLink.setPermissions(new BoxSharedLink.Permissions(permissions.getCanPreview(), permissions.getCanDownload(), false));
        }
        return sharedLink;
    }

    public Collection<BoxCollaboration.Info> getCollaborations(String ... fields) {
        BoxAPIConnection api = this.getAPI();
        QueryStringBuilder queryBuilder = new QueryStringBuilder();
        if (fields.length > 0) {
            queryBuilder.appendParam("fields", fields);
        }
        URL url = GET_COLLABORATIONS_URL.buildWithQuery(api.getBaseURL(), queryBuilder.toString(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            int entriesCount = responseJSON.get("total_count").asInt();
            ArrayList<BoxCollaboration.Info> collaborations = new ArrayList<BoxCollaboration.Info>(entriesCount);
            JsonArray entries = responseJSON.get("entries").asArray();
            for (JsonValue entry : entries) {
                BoxCollaboration collaboration;
                JsonObject entryObject = entry.asObject();
                BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
                boxCollaboration.getClass();
                BoxCollaboration.Info info = new BoxCollaboration.Info(boxCollaboration, entryObject);
                collaborations.add(info);
            }
            ArrayList<BoxCollaboration.Info> arrayList = collaborations;
            return arrayList;
        }
    }

    @Override
    public Info getInfo(String ... fields) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        if (fields.length > 0) {
            String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
            url = FOLDER_INFO_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            Info info = new Info(response.getJSON());
            return info;
        }
    }

    public void updateInfo(Info info) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            info.update(jsonObject);
        }
    }

    @Override
    public Info copy(BoxFolder destination) {
        return this.copy(destination, null);
    }

    @Override
    public Info copy(BoxFolder destination, String newName) {
        URL url = COPY_FOLDER_URL.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject copyInfo = new JsonObject();
        copyInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            copyInfo.add("name", newName);
        }
        request.setBody(copyInfo.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFolder copiedFolder;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxFolder boxFolder = copiedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
            boxFolder.getClass();
            Info info = boxFolder.new Info(responseJSON);
            return info;
        }
    }

    public Info createFolder(String name) {
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject newFolder = new JsonObject();
        newFolder.add("name", name);
        newFolder.add("parent", (JsonValue)parent);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), CREATE_FOLDER_URL.build(this.getAPI().getBaseURL(), new Object[0]), "POST");
        request.setBody(newFolder.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFolder createdFolder;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxFolder boxFolder = createdFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
            boxFolder.getClass();
            Info info = boxFolder.new Info(responseJSON);
            return info;
        }
    }

    public void delete(boolean recursive) {
        URL url = DELETE_FOLDER_URL.buildAlpha(this.getAPI().getBaseURL(), this.getID(), recursive);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    @Override
    public BoxItem.Info move(BoxFolder destination) {
        return this.move(destination, null);
    }

    @Override
    public BoxItem.Info move(BoxFolder destination, String newName) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            updateInfo.add("name", newName);
        }
        request.setBody(updateInfo.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFolder movedFolder;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxFolder boxFolder = movedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
            boxFolder.getClass();
            Info info = boxFolder.new Info(responseJSON);
            return info;
        }
    }

    public void rename(String newName) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("name", newName);
        request.setBody(updateInfo.toString());
        try (BoxJSONResponse response = request.send();){
            response.getJSON();
        }
    }

    public void canUpload(String name, long fileSize) {
        URL url = UPLOAD_FILE_URL.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "OPTIONS");
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject preflightInfo = new JsonObject();
        preflightInfo.add("parent", (JsonValue)parent);
        preflightInfo.add("name", name);
        preflightInfo.add("size", fileSize);
        request.setBody(preflightInfo.toString());
        try (BoxJSONResponse response = request.send();){
            response.getJSON();
        }
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(UploadFileCallback callback, String name) {
        FileUploadParams uploadInfo = new FileUploadParams().setUploadFileCallback(callback).setName(name);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name, long fileSize, ProgressListener listener) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name).setSize(fileSize).setProgressListener(listener);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name, String description) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name).setDescription(description);
        return this.uploadFile(uploadInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoxFile.Info uploadFile(FileUploadParams uploadParams) {
        URL uploadURL = UPLOAD_FILE_URL.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        BoxMultipartRequest request = new BoxMultipartRequest(this.getAPI(), uploadURL);
        JsonObject fieldJSON = new JsonObject();
        JsonObject parentIdJSON = new JsonObject();
        parentIdJSON.add("id", this.getID());
        fieldJSON.add("name", uploadParams.getName());
        fieldJSON.add("parent", (JsonValue)parentIdJSON);
        if (uploadParams.getCreated() != null) {
            fieldJSON.add("content_created_at", BoxDateFormat.format(uploadParams.getCreated()));
        }
        if (uploadParams.getModified() != null) {
            fieldJSON.add("content_modified_at", BoxDateFormat.format(uploadParams.getModified()));
        }
        if (uploadParams.getSHA1() != null && !uploadParams.getSHA1().isEmpty()) {
            request.setContentSHA1(uploadParams.getSHA1());
        }
        if (uploadParams.getDescription() != null) {
            fieldJSON.add("description", uploadParams.getDescription());
        }
        request.putField("attributes", fieldJSON.toString());
        if (uploadParams.getSize() > 0L) {
            request.setFile(uploadParams.getContent(), uploadParams.getName(), uploadParams.getSize());
        } else if (uploadParams.getContent() != null) {
            request.setFile(uploadParams.getContent(), uploadParams.getName());
        } else {
            request.setUploadFileCallback(uploadParams.getUploadFileCallback(), uploadParams.getName());
        }
        BoxJSONResponse response = null;
        try {
            BoxFile uploadedFile;
            response = uploadParams.getProgressListener() == null ? (BoxJSONResponse)request.send() : (BoxJSONResponse)request.send(uploadParams.getProgressListener());
            JsonObject collection = Json.parse((String)response.getJSON()).asObject();
            JsonArray entries = collection.get("entries").asArray();
            JsonObject fileInfoJSON = entries.get(0).asObject();
            String uploadedFileID = fileInfoJSON.get("id").asString();
            BoxFile boxFile = uploadedFile = new BoxFile(this.getAPI(), uploadedFileID);
            boxFile.getClass();
            BoxFile.Info info = boxFile.new BoxFile.Info(fileInfoJSON);
            return info;
        }
        finally {
            Optional.ofNullable(response).ifPresent(BoxAPIResponse::close);
        }
    }

    public BoxWebLink.Info createWebLink(URL linkURL) {
        return this.createWebLink(null, linkURL, null);
    }

    public BoxWebLink.Info createWebLink(String name, URL linkURL) {
        return this.createWebLink(name, linkURL, null);
    }

    public BoxWebLink.Info createWebLink(URL linkURL, String description) {
        return this.createWebLink(null, linkURL, description);
    }

    public BoxWebLink.Info createWebLink(String name, URL linkURL, String description) {
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject newWebLink = new JsonObject();
        newWebLink.add("name", name);
        newWebLink.add("parent", (JsonValue)parent);
        newWebLink.add("url", linkURL.toString());
        if (description != null) {
            newWebLink.add("description", description);
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), CREATE_WEB_LINK_URL.build(this.getAPI().getBaseURL(), new Object[0]), "POST");
        request.setBody(newWebLink.toString());
        try (BoxJSONResponse response = request.send();){
            BoxWebLink createdWebLink;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxWebLink boxWebLink = createdWebLink = new BoxWebLink(this.getAPI(), responseJSON.get("id").asString());
            boxWebLink.getClass();
            BoxWebLink.Info info = new BoxWebLink.Info(boxWebLink, responseJSON);
            return info;
        }
    }

    public Iterable<BoxItem.Info> getChildren() {
        return this;
    }

    public Iterable<BoxItem.Info> getChildren(String ... fields) {
        return () -> {
            String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
            URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
            return new BoxItemIterator(this.getAPI(), url, PagingParameters.marker(1000L));
        };
    }

    public Iterable<BoxItem.Info> getChildren(String sort, SortDirection direction, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("sort", sort).appendParam("direction", direction.toString());
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        String query = builder.toString();
        return () -> {
            URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), query, this.getID());
            return new BoxItemIterator(this.getAPI(), url, PagingParameters.offset(0L, 1000L));
        };
    }

    public Iterable<BoxItem.Info> getChildren(String sort, SortDirection direction, long offset, long limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("sort", sort).appendParam("direction", direction.toString());
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        String query = builder.toString();
        return () -> {
            URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), query, this.getID());
            return new BoxItemIterator(this.getAPI(), url, limit, offset);
        };
    }

    public PartialCollection<BoxItem.Info> getChildrenRange(long offset, long limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("limit", limit).appendParam("offset", offset);
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            String totalCountString = responseJSON.get("total_count").toString();
            long fullSize = Double.valueOf(totalCountString).longValue();
            PartialCollection<BoxItem.Info> children = new PartialCollection<BoxItem.Info>(offset, limit, fullSize);
            JsonArray jsonArray = responseJSON.get("entries").asArray();
            for (JsonValue value : jsonArray) {
                JsonObject jsonObject = value.asObject();
                BoxItem.Info parsedItemInfo = (BoxItem.Info)BoxResource.parseInfo(this.getAPI(), jsonObject);
                if (parsedItemInfo == null) continue;
                children.add(parsedItemInfo);
            }
            PartialCollection<BoxItem.Info> partialCollection = children;
            return partialCollection;
        }
    }

    public Iterable<BoxItem.Info> getChildren(SortParameters sortParameters, PagingParameters pagingParameters, String ... fields) {
        QueryStringBuilder builder = sortParameters.asQueryStringBuilder();
        this.validateSortIsSelectedWithOffsetPaginationOnly(pagingParameters, builder);
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        String query = builder.toString();
        return () -> {
            URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), query, this.getID());
            return new BoxItemIterator(this.getAPI(), url, pagingParameters);
        };
    }

    @Override
    public Iterator<BoxItem.Info> iterator() {
        URL url = GET_ITEMS_URL.build(this.getAPI().getBaseURL(), this.getID());
        return new BoxItemIterator(this.getAPI(), url, PagingParameters.marker(1000L));
    }

    public BoxWebHook.Info addWebHook(URL address, BoxWebHook.Trigger ... triggers) {
        return BoxWebHook.create((BoxResource)this, address, triggers);
    }

    public BoxWatermark getWatermark(String ... fields) {
        return this.getWatermark(FOLDER_INFO_URL_TEMPLATE, fields);
    }

    public BoxWatermark applyWatermark() {
        return this.applyWatermark(FOLDER_INFO_URL_TEMPLATE, "default");
    }

    public void removeWatermark() {
        this.removeWatermark(FOLDER_INFO_URL_TEMPLATE);
    }

    public Iterable<Metadata> getAllMetadata(String ... fields) {
        return Metadata.getAllMetadata(this, fields);
    }

    @Override
    public Info setCollections(BoxCollection ... collections) {
        JsonArray jsonArray = new JsonArray();
        for (BoxCollection collection : collections) {
            JsonObject collectionJSON = new JsonObject();
            collectionJSON.add("id", collection.getID());
            jsonArray.add((JsonValue)collectionJSON);
        }
        JsonObject infoJSON = new JsonObject();
        infoJSON.add("collections", (JsonValue)jsonArray);
        String queryString = new QueryStringBuilder().appendParam("fields", ALL_FIELDS).toString();
        URL url = FOLDER_INFO_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(infoJSON.toString());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            Info info = new Info(jsonObject);
            return info;
        }
    }

    public Metadata createMetadata(Metadata metadata) {
        return this.createMetadata("properties", metadata);
    }

    public Metadata createMetadata(String templateName, Metadata metadata) {
        String scope = Metadata.scopeBasedOnType(templateName);
        return this.createMetadata(templateName, scope, metadata);
    }

    public Metadata createMetadata(String templateName, String scope, Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(metadata.toString());
        try (BoxJSONResponse response = request.send();){
            Metadata metadata2 = new Metadata(Json.parse((String)response.getJSON()).asObject());
            return metadata2;
        }
    }

    public Metadata setMetadata(String templateName, String scope, Metadata metadata) {
        try {
            return this.createMetadata(templateName, scope, metadata);
        }
        catch (BoxAPIException e) {
            if (e.getResponseCode() == 409) {
                if (metadata.getOperations().isEmpty()) {
                    return this.getMetadata();
                }
                return this.updateExistingTemplate(templateName, scope, metadata);
            }
            throw e;
        }
    }

    private void validateSortIsSelectedWithOffsetPaginationOnly(PagingParameters pagingParameters, QueryStringBuilder sortQuery) {
        if (pagingParameters != null && pagingParameters.isMarkerBasedPaging() && sortQuery.toString().length() > 0) {
            throw new IllegalArgumentException("Sorting is not supported when using marker based pagination.");
        }
    }

    private Metadata updateExistingTemplate(String templateName, String scope, Metadata metadata) {
        Metadata metadataToUpdate = new Metadata(scope, templateName);
        for (JsonValue value : metadata.getOperations()) {
            if (value.asObject().get("value").isNumber()) {
                metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asDouble());
                continue;
            }
            if (value.asObject().get("value").isString()) {
                metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asString());
                continue;
            }
            if (!value.asObject().get("value").isArray()) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (JsonValue jsonValue : value.asObject().get("value").asArray()) {
                list.add(jsonValue.asString());
            }
            metadataToUpdate.add(value.asObject().get("path").asString(), list);
        }
        return this.updateMetadata(metadataToUpdate);
    }

    public Metadata getMetadata() {
        return this.getMetadata("properties");
    }

    public Metadata getMetadata(String templateName) {
        String scope = Metadata.scopeBasedOnType(templateName);
        return this.getMetadata(templateName, scope);
    }

    public Metadata getMetadata(String templateName, String scope) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            Metadata metadata = new Metadata(Json.parse((String)response.getJSON()).asObject());
            return metadata;
        }
    }

    public Metadata updateMetadata(Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), metadata.getScope(), metadata.getTemplateName());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT", "application/json-patch+json");
        request.setBody(metadata.getPatch());
        try (BoxJSONResponse response = request.send();){
            Metadata metadata2 = new Metadata(Json.parse((String)response.getJSON()).asObject());
            return metadata2;
        }
    }

    public void deleteMetadata() {
        this.deleteMetadata("properties");
    }

    public void deleteMetadata(String templateName) {
        String scope = Metadata.scopeBasedOnType(templateName);
        this.deleteMetadata(templateName, scope);
    }

    public void deleteMetadata(String templateName, String scope) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public String addClassification(String classificationType) {
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String updateClassification(String classificationType) {
        Metadata metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
        metadata.replace("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.updateMetadata(metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String setClassification(String classificationType) {
        Metadata classification;
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        try {
            classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        }
        catch (BoxAPIException e) {
            if (e.getResponseCode() == 409) {
                metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
                metadata.replace("/Box__Security__Classification__Key", classificationType);
                classification = this.updateMetadata(metadata);
            }
            throw e;
        }
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String getClassification() {
        Metadata metadata = this.getMetadata("securityClassification-6VMVochwUWo");
        return metadata.getString("/Box__Security__Classification__Key");
    }

    public void deleteClassification() {
        this.deleteMetadata("securityClassification-6VMVochwUWo", "enterprise");
    }

    public BoxFileUploadSession.Info createUploadSession(String fileName, long fileSize) {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject body = new JsonObject();
        body.add("folder_id", this.getID());
        body.add("file_name", fileName);
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFileUploadSession session;
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            String sessionId = jsonObject.get("id").asString();
            BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(this.getAPI(), sessionId);
            boxFileUploadSession.getClass();
            BoxFileUploadSession.Info info = boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
            return info;
        }
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        this.canUpload(fileName, fileSize);
        return new LargeFileUpload().upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize);
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        this.canUpload(fileName, fileSize);
        return new LargeFileUpload().upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize, fileAttributes);
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize, int nParallelConnections, long timeOut, TimeUnit unit) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        this.canUpload(fileName, fileSize);
        return new LargeFileUpload(nParallelConnections, timeOut, unit).upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize);
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize, int nParallelConnections, long timeOut, TimeUnit unit, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        this.canUpload(fileName, fileSize);
        return new LargeFileUpload(nParallelConnections, timeOut, unit).upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize, fileAttributes);
    }

    public BoxMetadataCascadePolicy.Info addMetadataCascadePolicy(String scope, String templateKey) {
        return BoxMetadataCascadePolicy.create(this.getAPI(), this.getID(), scope, templateKey);
    }

    public Iterable<BoxMetadataCascadePolicy.Info> getMetadataCascadePolicies(String ... fields) {
        return BoxMetadataCascadePolicy.getAll(this.getAPI(), this.getID(), fields);
    }

    public Iterable<BoxMetadataCascadePolicy.Info> getMetadataCascadePolicies(String enterpriseID, int limit, String ... fields) {
        return BoxMetadataCascadePolicy.getAll(this.getAPI(), this.getID(), enterpriseID, limit, fields);
    }

    public BoxFolderLock.Info lock() {
        JsonObject folderObject = new JsonObject();
        folderObject.add("type", TYPE);
        folderObject.add("id", this.getID());
        JsonObject lockedOperations = new JsonObject();
        lockedOperations.add("move", true);
        lockedOperations.add("delete", true);
        JsonObject body = new JsonObject();
        body.add(TYPE, (JsonValue)folderObject);
        body.add("locked_operations", (JsonValue)lockedOperations);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), FOLDER_LOCK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]), "POST");
        request.setBody(body.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFolderLock createdFolderLock;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxFolderLock boxFolderLock = createdFolderLock = new BoxFolderLock(this.getAPI(), responseJSON.get("id").asString());
            boxFolderLock.getClass();
            BoxFolderLock.Info info = new BoxFolderLock.Info(boxFolderLock, responseJSON);
            return info;
        }
    }

    public Iterable<BoxFolderLock.Info> getLocks() {
        String queryString = new QueryStringBuilder().appendParam("folder_id", this.getID()).toString();
        final BoxAPIConnection api = this.getAPI();
        return new BoxResourceIterable<BoxFolderLock.Info>(api, FOLDER_LOCK_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString, new Object[0]), 100){

            @Override
            protected BoxFolderLock.Info factory(JsonObject jsonObject) {
                BoxFolderLock folderLock;
                BoxFolderLock boxFolderLock = folderLock = new BoxFolderLock(api, jsonObject.get("id").asString());
                boxFolderLock.getClass();
                return new BoxFolderLock.Info(boxFolderLock, jsonObject);
            }
        };
    }

    public class Info
    extends BoxItem.Info {
        private BoxUploadEmail uploadEmail;
        private boolean hasCollaborations;
        private SyncState syncState;
        private EnumSet<Permission> permissions;
        private boolean canNonOwnersInvite;
        private boolean isWatermarked;
        private boolean isCollaborationRestrictedToEnterprise;
        private boolean isExternallyOwned;
        private Map<String, Map<String, Metadata>> metadataMap;
        private List<String> allowedSharedLinkAccessLevels;
        private List<String> allowedInviteeRoles;
        private BoxClassification classification;
        private boolean isAccessibleViaSharedLink;
        private boolean canNonOwnersViewCollaborators;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        public Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxUploadEmail getUploadEmail() {
            return this.uploadEmail;
        }

        public void setUploadEmail(BoxUploadEmail uploadEmail) {
            if (this.uploadEmail == uploadEmail) {
                return;
            }
            this.removeChildObject("folder_upload_email");
            this.uploadEmail = uploadEmail;
            if (uploadEmail == null) {
                this.addPendingChange("folder_upload_email", (String)null);
            } else {
                this.addChildObject("folder_upload_email", uploadEmail);
            }
        }

        public boolean getHasCollaborations() {
            return this.hasCollaborations;
        }

        public SyncState getSyncState() {
            return this.syncState;
        }

        public void setSyncState(SyncState syncState) {
            this.syncState = syncState;
            this.addPendingChange("sync_state", syncState.toJSONValue());
        }

        public EnumSet<Permission> getPermissions() {
            return this.permissions;
        }

        public boolean getCanNonOwnersInvite() {
            return this.canNonOwnersInvite;
        }

        public void setCanNonOwnersInvite(boolean canNonOwnersInvite) {
            this.canNonOwnersInvite = canNonOwnersInvite;
            this.addPendingChange("can_non_owners_invite", canNonOwnersInvite);
        }

        public boolean getIsCollaborationRestrictedToEnterprise() {
            return this.isCollaborationRestrictedToEnterprise;
        }

        public void setIsCollaborationRestrictedToEnterprise(boolean isRestricted) {
            this.isCollaborationRestrictedToEnterprise = isRestricted;
            this.addPendingChange("is_collaboration_restricted_to_enterprise", isRestricted);
        }

        public List<String> getAllowedInviteeRoles() {
            return this.allowedInviteeRoles;
        }

        public List<String> getAllowedSharedLinkAccessLevels() {
            return this.allowedSharedLinkAccessLevels;
        }

        public boolean getIsWatermarked() {
            return this.isWatermarked;
        }

        public Metadata getMetadata(String templateName, String scope) {
            try {
                return this.metadataMap.get(scope).get(templateName);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        public boolean getIsExternallyOwned() {
            return this.isExternallyOwned;
        }

        public BoxClassification getClassification() {
            return this.classification;
        }

        public boolean getIsAccessibleViaSharedLink() {
            return this.isAccessibleViaSharedLink;
        }

        public boolean getCanNonOwnersViewCollaborators() {
            return this.canNonOwnersViewCollaborators;
        }

        public void setCanNonOwnersViewCollaborators(boolean canNonOwnersViewCollaborators) {
            this.canNonOwnersViewCollaborators = canNonOwnersViewCollaborators;
            this.addPendingChange("can_non_owners_view_collaborators", canNonOwnersViewCollaborators);
        }

        @Override
        public BoxFolder getResource() {
            return BoxFolder.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                switch (memberName) {
                    case "folder_upload_email": {
                        if (this.uploadEmail == null) {
                            this.uploadEmail = new BoxUploadEmail(value.asObject());
                            break;
                        }
                        this.uploadEmail.update(value.asObject());
                        break;
                    }
                    case "has_collaborations": {
                        this.hasCollaborations = value.asBoolean();
                        break;
                    }
                    case "sync_state": {
                        this.syncState = SyncState.fromJSONValue(value.asString());
                        break;
                    }
                    case "permissions": {
                        this.permissions = this.parsePermissions(value.asObject());
                        break;
                    }
                    case "can_non_owners_invite": {
                        this.canNonOwnersInvite = value.asBoolean();
                        break;
                    }
                    case "allowed_shared_link_access_levels": {
                        this.allowedSharedLinkAccessLevels = this.parseSharedLinkAccessLevels(value.asArray());
                        break;
                    }
                    case "allowed_invitee_roles": {
                        this.allowedInviteeRoles = this.parseAllowedInviteeRoles(value.asArray());
                        break;
                    }
                    case "is_collaboration_restricted_to_enterprise": {
                        this.isCollaborationRestrictedToEnterprise = value.asBoolean();
                        break;
                    }
                    case "is_externally_owned": {
                        this.isExternallyOwned = value.asBoolean();
                        break;
                    }
                    case "watermark_info": {
                        this.isWatermarked = value.asObject().get("is_watermarked").asBoolean();
                        break;
                    }
                    case "metadata": {
                        this.metadataMap = Parsers.parseAndPopulateMetadataMap(value.asObject());
                        break;
                    }
                    case "classification": {
                        if (value.isNull()) {
                            this.classification = null;
                            break;
                        }
                        this.classification = new BoxClassification(value.asObject());
                        break;
                    }
                    case "is_accessible_via_shared_link": {
                        this.isAccessibleViaSharedLink = value.asBoolean();
                        break;
                    }
                    case "can_non_owners_view_collaborators": {
                        this.canNonOwnersViewCollaborators = value.asBoolean();
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
            EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
            for (JsonObject.Member member : jsonObject) {
                JsonValue value = member.getValue();
                if (value.isNull() || !value.asBoolean()) continue;
                try {
                    permissions.add(Permission.fromJSONValue(member.getName()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return permissions;
        }

        private List<String> parseSharedLinkAccessLevels(JsonArray jsonArray) {
            ArrayList<String> accessLevels = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                accessLevels.add(value.asString());
            }
            return accessLevels;
        }

        private List<String> parseAllowedInviteeRoles(JsonArray jsonArray) {
            ArrayList<String> roles = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                roles.add(value.asString());
            }
            return roles;
        }
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_INVITE_COLLABORATOR("can_invite_collaborator"),
        CAN_SET_SHARE_ACCESS("can_set_share_access");

        private final String jsonValue;

        private Permission(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Permission fromJSONValue(String jsonValue) {
            return Permission.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum SyncState {
        SYNCED("synced"),
        NOT_SYNCED("not_synced"),
        PARTIALLY_SYNCED("partially_synced");

        private final String jsonValue;

        private SyncState(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static SyncState fromJSONValue(String jsonValue) {
            return SyncState.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

