/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BoxLogger {
    private static final BoxLogger DEFAULT_LOGGER = new BoxLogger("com.box.sdk");
    private final Logger logger;

    private BoxLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public static BoxLogger defaultLogger() {
        return DEFAULT_LOGGER;
    }

    public void debug(String message) {
        this.logger.fine(message);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void warn(String message) {
        this.logger.warning(message);
    }

    public void error(String message) {
        this.logger.severe(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void setLevelToAll() {
        this.logger.setLevel(Level.ALL);
    }

    public void resetToDefaultLevel() {
        this.logger.setLevel(null);
    }

    public void setLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLevelToWarning() {
        this.logger.setLevel(Level.WARNING);
    }

    public void setLevelToError() {
        this.logger.setLevel(Level.SEVERE);
    }

    public void turnLoggingOff() {
        this.logger.setLevel(Level.OFF);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    public void addHandler(Handler handler) {
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.logger.removeHandler(handler);
    }
}

