/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAIAgentEmbeddings;
import com.box.sdk.BoxAIAgentLLMEndpointParams;
import com.box.sdk.BoxAIAgentLLMEndpointParamsOpenAI;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

public class BoxAIAgentTextGenBasicGen
extends BoxJSONObject {
    private String contentTemplate;
    private BoxAIAgentEmbeddings embeddings;
    private BoxAIAgentLLMEndpointParams llmEndpointParams;
    private String model;
    private int numTokensForCompletion;
    private String promptTemplate;
    private String systemMessage;

    public BoxAIAgentTextGenBasicGen(String contentTemplate, BoxAIAgentEmbeddings embeddings, BoxAIAgentLLMEndpointParamsOpenAI llmEndpointParams, String model, int numTokensForCompletion, String promptTemplate, String systemMessage) {
        this.contentTemplate = contentTemplate;
        this.embeddings = embeddings;
        this.llmEndpointParams = llmEndpointParams;
        this.model = model;
        this.numTokensForCompletion = numTokensForCompletion;
        this.promptTemplate = promptTemplate;
        this.systemMessage = systemMessage;
    }

    public BoxAIAgentTextGenBasicGen(JsonObject jsonObject) {
        super(jsonObject);
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public BoxAIAgentEmbeddings getEmbeddings() {
        return this.embeddings;
    }

    public void setEmbeddings(BoxAIAgentEmbeddings embeddings) {
        this.embeddings = embeddings;
    }

    public BoxAIAgentLLMEndpointParams getLlmEndpointParams() {
        return this.llmEndpointParams;
    }

    public void setLlmEndpointParams(BoxAIAgentLLMEndpointParamsOpenAI llmEndpointParams) {
        this.llmEndpointParams = llmEndpointParams;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getNumTokensForCompletion() {
        return this.numTokensForCompletion;
    }

    public void setNumTokensForCompletion(int numTokensForCompletion) {
        this.numTokensForCompletion = numTokensForCompletion;
    }

    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    public void setPromptTemplate(String promptTemplate) {
        this.promptTemplate = promptTemplate;
    }

    public String getSystemMessage() {
        return this.systemMessage;
    }

    public void setSystemMessage(String systemMessage) {
        this.systemMessage = systemMessage;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        String memberName;
        super.parseJSONMember(member);
        switch (memberName = member.getName()) {
            case "content_template": {
                this.contentTemplate = member.getValue().asString();
                break;
            }
            case "embeddings": {
                this.embeddings = new BoxAIAgentEmbeddings(member.getValue().asObject());
                break;
            }
            case "llm_endpoint_params": {
                this.llmEndpointParams = BoxAIAgentLLMEndpointParams.parse(member.getValue().asObject());
                break;
            }
            case "model": {
                this.model = member.getValue().asString();
                break;
            }
            case "num_tokens_for_completion": {
                this.numTokensForCompletion = member.getValue().asInt();
                break;
            }
            case "prompt_template": {
                this.promptTemplate = member.getValue().asString();
                break;
            }
            case "system_message": {
                this.systemMessage = member.getValue().asString();
                break;
            }
        }
    }

    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        JsonUtils.addIfNotNull(jsonObject, "content_template", this.contentTemplate);
        if (this.embeddings != null) {
            jsonObject.add("embeddings", (JsonValue)this.embeddings.getJSONObject());
        }
        if (this.llmEndpointParams != null) {
            jsonObject.add("llm_endpoint_params", (JsonValue)this.llmEndpointParams.getJSONObject());
        }
        JsonUtils.addIfNotNull(jsonObject, "model", this.model);
        JsonUtils.addIfNotNull(jsonObject, "num_tokens_for_completion", this.numTokensForCompletion);
        JsonUtils.addIfNotNull(jsonObject, "prompt_template", this.promptTemplate);
        JsonUtils.addIfNotNull(jsonObject, "system_message", this.systemMessage);
        return jsonObject;
    }
}

