/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;

public abstract class DualPathOperation
implements JsonPatchOperation {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final String op;
    @JsonSerialize(using=ToStringSerializer.class)
    protected final JsonPointer from;
    protected final JsonPointer path;

    protected DualPathOperation(String op, JsonPointer from, JsonPointer path) {
        this.op = op;
        this.from = from;
        this.path = path;
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.op);
        jgen.writeStringField("path", this.path.toString());
        jgen.writeStringField("from", this.from.toString());
        jgen.writeEndObject();
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public final String toString() {
        return "op: " + this.op + "; from: \"" + this.from + "\"; path: \"" + this.path + '\"';
    }
}

