/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.PathValueOperation;
import com.github.fge.jsonpatch.operation.policy.PathMissingPolicy;
import com.google.common.base.Equivalence;
import com.google.common.collect.Iterables;

public abstract class OmitOperationBase
extends PathValueOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private PathMissingPolicy pathMissingPolicy;

    public OmitOperationBase(String op, JsonPointer path, JsonNode value, PathMissingPolicy pathMissingPolicy) {
        super(op, path, value);
        this.pathMissingPolicy = pathMissingPolicy;
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode ret = node.deepCopy();
        if (this.path.isEmpty()) {
            if (EQUIVALENCE.equivalent((Object)ret, (Object)this.value)) {
                return MissingNode.getInstance();
            }
            return ret;
        }
        JsonNode valueAtPath = (JsonNode)this.path.path((TreeNode)ret);
        if (valueAtPath.isMissingNode()) {
            switch (this.pathMissingPolicy) {
                case THROW: {
                    throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
                }
                case SKIP: {
                    return ret;
                }
            }
        }
        if (EQUIVALENCE.equivalent((Object)valueAtPath, (Object)this.value)) {
            JsonNode parent = (JsonNode)this.path.parent().get((TreeNode)ret);
            String rawToken = ((TokenResolver)Iterables.getLast((Iterable)this.path)).getToken().getRaw();
            if (parent.isObject()) {
                ((ObjectNode)parent).remove(rawToken);
            } else {
                ((ArrayNode)parent).remove(Integer.parseInt(rawToken));
            }
        }
        return ret;
    }
}

